/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.ForgeKeys;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.messages.IForgeMsgHandler;
import com.endertech.minecraft.forge.messages.KeyPressedMsg;
import com.endertech.minecraft.forge.regs.ForgeRegistrator;
import com.endertech.minecraft.forge.units.ForgeItem;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adhooks.Hook;
import com.endertech.minecraft.mods.adhooks.init.HookType;
import com.endertech.minecraft.mods.adhooks.init.Main;
import com.endertech.minecraft.mods.adhooks.shot.HookShot;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HookLauncher
extends ForgeItem {
    public static final String TAG_HOOKSHOT_ID = "hookShotId";
    public static final FloatBounds REELING_SPEED_BOUNDS = new FloatBounds(0.1f, 4.0f);
    public static final IntBounds DURABILITY_BOUNDS = new IntBounds(1, 1000);
    public static final int DAMAGE_ON_SHOT = 1;
    protected ConcurrentHashMap<KeyBinding, Boolean> watchedKeys = new ConcurrentHashMap();
    protected HashSet<ItemStack> queuedShots = new HashSet();
    protected ModelResourceLocation attachedModel;
    public final Hook hook;
    public final float reelingSpeed;
    public final int durability;

    public HookLauncher(String modId, String name, ForgeRegistrator registrator, UnitConfig config, Hook hook, int durability, float reelingSpeed) {
        super(modId, name, registrator, CreativeTabs.field_78040_i, config);
        String category = this.id.unitName;
        this.hook = hook;
        this.durability = UnitConfig.getInt((ForgeConfig)config, (String)category, (String)"durability", (int)durability, (IntBounds)DURABILITY_BOUNDS, (String)"Defines how many times the launcher can be used");
        this.reelingSpeed = UnitConfig.getFloat((ForgeConfig)config, (String)category, (String)"reelingSpeed", (float)reelingSpeed, (FloatBounds)REELING_SPEED_BOUNDS, (String)"Defines how fast the launcher reels in the rope.");
        assert (hook != null);
        this.func_77625_d(1);
        this.func_77656_e(this.durability);
        this.func_77664_n();
    }

    public boolean func_82788_x() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack launcher, EntityPlayer player, List<String> tooltip, boolean advanced) {
        GameSettings gs = ForgeKeys.getGameSettings();
        if (ForgeKeys.isDown((KeyBinding)gs.field_151444_V)) {
            tooltip.add(ChatFormatting.RED + "Hook strength: " + this.hook.strength);
            tooltip.add(ChatFormatting.GREEN + "Rope elasticity: " + this.hook.type.rope.elasticity);
            tooltip.add(ChatFormatting.YELLOW + "Rope max length: " + this.hook.type.rope.maxLength);
            tooltip.add(ChatFormatting.AQUA + "Reeling speed: " + this.hook.type.launcher.reelingSpeed);
        } else if (ForgeKeys.isDown((KeyBinding)gs.field_74311_E)) {
            tooltip.add(ChatFormatting.RED + "Launch: " + ForgeKeys.getName((KeyBinding)gs.field_74312_F));
            tooltip.add(ChatFormatting.GREEN + "Reel / Unhook: " + ForgeKeys.getName((KeyBinding)gs.field_74316_C));
            tooltip.add(ChatFormatting.YELLOW + "Pull: hold " + ForgeKeys.getName((KeyBinding)gs.field_74313_G));
            tooltip.add(ChatFormatting.AQUA + "Loosen: hold " + ForgeKeys.getName((KeyBinding)gs.field_74312_F));
            tooltip.add(ChatFormatting.GOLD + "Boost up: press " + ForgeKeys.getName((KeyBinding)gs.field_74316_C) + " while pulling");
            tooltip.add(ChatFormatting.LIGHT_PURPLE + "Release: hold " + ForgeKeys.getName((KeyBinding)gs.field_74311_E) + " and press " + ForgeKeys.getName((KeyBinding)gs.field_74312_F));
        } else {
            tooltip.add("hold " + ForgeKeys.getName((KeyBinding)gs.field_151444_V) + " for more info");
            tooltip.add("hold " + ForgeKeys.getName((KeyBinding)gs.field_74311_E) + " for control help");
        }
    }

    public static boolean isAttached(ItemStack launcher) {
        return HookLauncher.stackHasLauncher(launcher) && launcher.func_77942_o() && launcher.func_77978_p().func_74764_b(TAG_HOOKSHOT_ID);
    }

    public static boolean isAttachedToHookShot(ItemStack launcher, HookShot hookShot) {
        return HookLauncher.isAttached(launcher) && hookShot != null && HookLauncher.getAttachedHookShotId(launcher) == hookShot.func_145782_y();
    }

    public static int getAttachedHookShotId(ItemStack launcher) {
        if (launcher != null && launcher.func_77942_o()) {
            return launcher.func_77978_p().func_74762_e(TAG_HOOKSHOT_ID);
        }
        return 0;
    }

    public static boolean stackHasLauncher(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof HookLauncher;
    }

    @Nullable
    public static HookShot findAttachedHookShot(ItemStack launcher, World world) {
        Entity entity;
        if (HookLauncher.isAttached(launcher) && world != null && (entity = world.func_73045_a(HookLauncher.getAttachedHookShotId(launcher))) instanceof HookShot) {
            return (HookShot)entity;
        }
        return null;
    }

    @Nullable
    public static ItemStack findAttachedLauncher(InventoryPlayer inventory, HookShot hookShot) {
        if (inventory != null && inventory.field_70462_a != null && hookShot != null) {
            for (ItemStack stack : inventory.field_70462_a) {
                if (!HookLauncher.isAttachedToHookShot(stack, hookShot)) continue;
                return stack;
            }
        }
        return null;
    }

    public static void attachToHookShot(ItemStack launcher, HookShot hookShot) {
        if (HookLauncher.stackHasLauncher(launcher) && hookShot != null) {
            HookLauncher.ensureHasNBT((ItemStack)launcher);
            NBTTagCompound tag = launcher.func_77978_p();
            tag.func_74768_a(TAG_HOOKSHOT_ID, hookShot.func_145782_y());
        }
    }

    public static void unattach(ItemStack launcher) {
        if (HookLauncher.stackHasLauncher(launcher) && HookLauncher.hasNBT((ItemStack)launcher)) {
            launcher.func_77978_p().func_82580_o(TAG_HOOKSHOT_ID);
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        HookLauncher.ensureHasNBT((ItemStack)stack);
    }

    public boolean onDroppedByPlayer(ItemStack launcher, EntityPlayer player) {
        if (ForgeEntity.isServerSide((Entity)player)) {
            HookShot hookShot = HookLauncher.findAttachedHookShot(launcher, player.field_70170_p);
            if (hookShot != null) {
                hookShot.setState(HookShot.State.reeling);
                return false;
            }
            if (player.func_184587_cr()) {
                return false;
            }
        }
        return super.onDroppedByPlayer(launcher, player);
    }

    public boolean onLeftClickEntity(ItemStack launcher, EntityPlayer player, Entity entity) {
        return this.hook != null && this.hook.type != HookType.pudge;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public void queueShot(ItemStack launcher) {
        this.queuedShots.add(launcher);
    }

    protected void makeShot(ItemStack launcher, World world, EntityLivingBase shooter) {
        if (this.isServerSide(world) && launcher != null && this.hook != null && this.hook.type != null && HookLauncher.notBroken((ItemStack)launcher)) {
            HookShot hookShot = new HookShot(world, shooter, this.hook.type);
            world.func_72838_d((Entity)hookShot);
            HookLauncher.attachToHookShot(launcher, hookShot);
            HookLauncher.damageItem((int)1, (ItemStack)launcher, (EntityLivingBase)shooter, (boolean)false);
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public boolean func_82789_a(ItemStack launcher, ItemStack material) {
        return material != null && material.func_77973_b() == Items.field_151007_F;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack launcher, World world, EntityPlayer player, EnumHand hand) {
        if (player != null) {
            player.func_184598_c(hand);
        }
        return super.func_77659_a(launcher, world, player, hand);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public String getClassDictionaryName() {
        return "hooklauncher";
    }

    @SideOnly(value=Side.CLIENT)
    public void onInitClient() {
        this.attachedModel = new UnitId(this.id.modId, this.id.unitName + "Attached", this.id.meta).toModelResLoc_Inventory();
        GameSettings gs = ForgeKeys.getGameSettings();
        this.watchedKeys.put(gs.field_74312_F, false);
        this.watchedKeys.put(gs.field_74313_G, false);
        this.watchedKeys.put(gs.field_74316_C, false);
        ItemMeshDefinition definition = stack -> HookLauncher.isAttached(stack) ? this.attachedModel : this.id.toModelResLoc_Inventory();
        this.getRegistrator().registerItemModel((Item)this, definition, new ResourceLocation[]{this.attachedModel, this.id.toModelResLoc_Inventory()});
    }

    @SideOnly(value=Side.CLIENT)
    public void processPressedKeys() {
        GameSettings gs = ForgeKeys.getGameSettings();
        if (ForgeKeys.affectPlayer()) {
            for (KeyBinding keyBinding : this.watchedKeys.keySet()) {
                KeyPressedMsg.Keys key;
                boolean isKeyDown;
                boolean wasKeyDown = this.watchedKeys.get(keyBinding);
                if (wasKeyDown == (isKeyDown = ForgeKeys.isDown((KeyBinding)keyBinding))) continue;
                if (keyBinding == gs.field_74312_F) {
                    key = KeyPressedMsg.Keys.attack;
                } else if (keyBinding == gs.field_74313_G) {
                    key = KeyPressedMsg.Keys.use;
                } else {
                    if (keyBinding != gs.field_74316_C) continue;
                    key = KeyPressedMsg.Keys.drop;
                }
                KeyPressedMsg message = new KeyPressedMsg(key, isKeyDown);
                Main.registrator.networkChannel.sendToServer((IMessage)message);
                this.watchedKeys.put(keyBinding, isKeyDown);
            }
        }
    }

    public void func_77663_a(ItemStack launcher, World world, Entity shooter, int inventorySlot, boolean isCurrentItem) {
        if (this.isClientSide(world) && isCurrentItem) {
            this.processPressedKeys();
        }
        if (this.isServerSide(world) && shooter instanceof EntityLivingBase && this.queuedShots.contains(launcher)) {
            this.makeShot(launcher, world, (EntityLivingBase)shooter);
            this.queuedShots.remove(launcher);
        }
        super.func_77663_a(launcher, world, shooter, inventorySlot, isCurrentItem);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return true;
    }

    public static class KeyPressHandler
    implements IForgeMsgHandler<KeyPressedMsg> {
        public IMessage onMessage(KeyPressedMsg message, MessageContext ctx) {
            if (message != null && ctx != null) {
                World world = this.getWorld(ctx);
                EntityPlayer player = this.getPlayer(ctx);
                ItemStack stack = player.field_71071_by.func_70448_g();
                if (HookLauncher.stackHasLauncher(stack)) {
                    if (HookLauncher.isAttached(stack)) {
                        HookShot hookShot = HookLauncher.findAttachedHookShot(stack, world);
                        if (hookShot != null) {
                            switch (message.key) {
                                case attack: {
                                    hookShot.setIsLoosening(message.isDown);
                                    break;
                                }
                                case use: {
                                    hookShot.setIsPulling(message.isDown);
                                    break;
                                }
                                case drop: {
                                    if (hookShot.getIsPulling() && hookShot.isHookingBlock()) {
                                        hookShot.boostUpShooter();
                                    } else {
                                        break;
                                    }
                                }
                            }
                        } else {
                            HookLauncher.unattach(stack);
                        }
                    } else if (message.key == KeyPressedMsg.Keys.attack && message.isDown) {
                        HookLauncher launcher = (HookLauncher)stack.func_77973_b();
                        launcher.queueShot(stack);
                    }
                }
            }
            return null;
        }
    }
}

