/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IHaveConfig;

public class Rope
implements IHaveConfig {
    public static final IntBounds LENGTH_BOUNDS = new IntBounds(1, 80);
    public static final FloatBounds WIDTH_BOUNDS = new FloatBounds(1.0f, 10.0f);
    public static final FloatBounds ELASTICITY_BOUNDS = new FloatBounds(0.0f, 0.95f);
    public static final FloatBounds MOTION_REDUCTION_BOUNDS = new FloatBounds(0.55f, 0.8f);
    public final int segmentsAmount = 16;
    public final ColorARGB color;
    public final int maxLength;
    public final float width;
    public final float elasticity;
    protected final ForgeConfig config;

    public Rope(ForgeConfig config, int maxLength, float width, float elasticity, int colorARGB) {
        String category = this.getClass().getSimpleName();
        String hexARGB = ForgeConfig.getStr((ForgeConfig)config, (String)category, (String)"color", (String)ColorARGB.getHexARGB((int)colorARGB), (String)"Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)");
        this.config = config;
        this.color = new ColorARGB(hexARGB);
        this.maxLength = ForgeConfig.getInt((ForgeConfig)config, (String)category, (String)"maxLength", (int)maxLength, (IntBounds)LENGTH_BOUNDS, (String)"Defines the maximal rope length.");
        this.width = ForgeConfig.getFloat((ForgeConfig)config, (String)category, (String)"width", (float)width, (FloatBounds)WIDTH_BOUNDS, (String)"Defines rope width.");
        this.elasticity = ForgeConfig.getFloat((ForgeConfig)config, (String)category, (String)"elasticity", (float)elasticity, (FloatBounds)ELASTICITY_BOUNDS, (String)"Defines how elastic the rope is.");
    }

    public float getMotionReduction() {
        return CommonMath.getApproxDown((float)this.elasticity, (FloatBounds)MOTION_REDUCTION_BOUNDS);
    }

    public float getTensionForce(float ropeLength, float realDistance) {
        float diff = realDistance - ropeLength;
        float ropeStrength = this.getRopeStrength();
        return diff * ropeStrength;
    }

    public float getRopeStrength() {
        return CommonMath.getApproxDown((float)this.elasticity, (FloatBounds)ELASTICITY_BOUNDS);
    }

    public ForgeConfig getConfig() {
        return this.config;
    }
}

