/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.init;

import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.mods.adhooks.Hook;
import com.endertech.minecraft.mods.adhooks.HookLauncher;
import com.endertech.minecraft.mods.adhooks.Rope;
import com.endertech.minecraft.mods.adhooks.init.Main;
import java.nio.file.Path;

public enum HookType {
    pudge(4.0f, 0.0f, 100, 0.7f, 20, 3.0f, 0.0f, -4259840),
    spear(2.5f, 2.0f, 60, 0.6f, 40, 4.0f, 0.5f, -1090519040),
    web(1.0f, 0.0f, 80, 0.8f, 30, 6.0f, 0.95f, -1);

    public final Hook hook;
    public final Rope rope;
    public final HookLauncher launcher;

    private HookType(float hookStrength, float hookDamage, int durability, float reelingSpeed, int ropeMaxLength, float ropeWidth, float ropeElasticity, int ropeColorARGB) {
        Path configDir = Main.config.getConfigDir();
        UnitConfig hookConfig = new UnitConfig(configDir.resolve("hooks"), this.name());
        this.hook = new Hook("AdHooks", Main.registrator, hookConfig, this, hookStrength, hookDamage);
        UnitConfig launcherConfig = new UnitConfig(configDir.resolve("launchers"), this.name());
        this.rope = new Rope((ForgeConfig)launcherConfig, ropeMaxLength, ropeWidth, ropeElasticity, ropeColorARGB);
        this.launcher = new HookLauncher("AdHooks", this.name(), Main.registrator, launcherConfig, this.hook, durability, reelingSpeed);
        hookConfig.save();
        launcherConfig.save();
    }
}

