/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.shot;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.ForgeWorld;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.entities.Rotation;
import com.endertech.minecraft.forge.math.ForgeMath;
import com.endertech.minecraft.forge.math.ForgeVec3d;
import com.endertech.minecraft.forge.messages.MotionMsg;
import com.endertech.minecraft.forge.units.ForgeBlock;
import com.endertech.minecraft.mods.adhooks.Hook;
import com.endertech.minecraft.mods.adhooks.HookLauncher;
import com.endertech.minecraft.mods.adhooks.Rope;
import com.endertech.minecraft.mods.adhooks.init.HookType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HookShot
extends ForgeEntity
implements IThrowableEntity,
IProjectile {
    public static final float GRAVITY_VELOCITY = 0.005f;
    public static final int RENDER_DISTANCE = Rope.LENGTH_BOUNDS.max;
    protected float shootStrength = 1.5f;
    protected float size = 0.6f;
    protected ConcurrentHashMap<Entity, ForgeVec3d> lastAddedMotionsList = new ConcurrentHashMap();

    public HookShot(World world) {
        super(world);
        this.func_70105_a(this.size, this.size);
        this.field_70158_ak = true;
    }

    public HookShot(World world, EntityLivingBase shooter, HookType hookType) {
        this(world);
        this.field_70180_af.func_187227_b(WatchedInt.shooterId.key, (Object)ForgeEntity.getId((Entity)shooter));
        this.setHookType(hookType);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        this.field_70165_t -= (double)(ForgeMath.cos((float)this.field_70177_z) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(ForgeMath.sin((float)this.field_70177_z) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -ForgeMath.sin((float)this.field_70177_z) * ForgeMath.cos((float)this.field_70125_A);
        this.field_70179_y = ForgeMath.cos((float)this.field_70177_z) * ForgeMath.cos((float)this.field_70125_A);
        this.field_70181_x = -ForgeMath.sin((float)this.field_70125_A);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.shootStrength, 1.0f);
        if (world != null && shooter != null) {
            world.func_184148_a((EntityPlayer)null, shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.2f) + 0.5f);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        for (WatchedBool watchedBool : WatchedBool.values()) {
            this.field_70180_af.func_187214_a(watchedBool.key, (Object)false);
        }
        for (Enum enum_ : WatchedInt.values()) {
            this.field_70180_af.func_187214_a(((WatchedInt)enum_).key, (Object)0);
        }
        for (Enum enum_ : WatchedFloat.values()) {
            this.field_70180_af.func_187214_a(((WatchedFloat)enum_).key, (Object)Float.valueOf(0.0f));
        }
        this.setState(State.shooting);
    }

    public boolean getIsLoosening() {
        return (Boolean)this.field_70180_af.func_187225_a(WatchedBool.isLoosening.key);
    }

    public void setIsLoosening(boolean isLoosening) {
        this.field_70180_af.func_187227_b(WatchedBool.isLoosening.key, (Object)isLoosening);
    }

    public boolean getIsPulling() {
        return (Boolean)this.field_70180_af.func_187225_a(WatchedBool.isPulling.key);
    }

    public void setIsPulling(boolean isPulling) {
        this.field_70180_af.func_187227_b(WatchedBool.isPulling.key, (Object)isPulling);
    }

    public State getPrevState() {
        int i = (Integer)this.field_70180_af.func_187225_a(WatchedInt.prevState.key);
        return State.values()[i];
    }

    public State getState() {
        int i = (Integer)this.field_70180_af.func_187225_a(WatchedInt.state.key);
        return State.values()[i];
    }

    public void setState(State state) {
        State prevState = this.getState();
        if (state != prevState) {
            this.field_70180_af.func_187227_b(WatchedInt.prevState.key, (Object)prevState.ordinal());
            this.field_70180_af.func_187227_b(WatchedInt.state.key, (Object)state.ordinal());
        }
    }

    public float getRopeLength() {
        return ((Float)this.field_70180_af.func_187225_a(WatchedFloat.ropeLength.key)).floatValue();
    }

    public void setRopeLength(float ropeLength) {
        this.field_70180_af.func_187227_b(WatchedFloat.ropeLength.key, (Object)Float.valueOf(ropeLength));
    }

    public float getSagging() {
        return ((Float)this.field_70180_af.func_187225_a(WatchedFloat.sagging.key)).floatValue();
    }

    public void setSagging(float sagging) {
        if (sagging < 0.0f) {
            sagging = 0.0f;
        }
        this.field_70180_af.func_187227_b(WatchedFloat.sagging.key, (Object)Float.valueOf(sagging));
    }

    public void setHookType(HookType value) {
        if (value != null) {
            this.field_70180_af.func_187227_b(WatchedInt.hookType.key, (Object)value.ordinal());
        }
    }

    public HookType getHookType() {
        int ordinal = (Integer)this.field_70180_af.func_187225_a(WatchedInt.hookType.key);
        return HookType.values()[ordinal];
    }

    public boolean canHookOnReeling() {
        return this.getHookType() == HookType.pudge;
    }

    public boolean canHookBlocks() {
        return this.getHookType() != HookType.pudge;
    }

    public boolean canHookEntities() {
        return true;
    }

    protected ForgeVec3d getHitPosition() {
        return new ForgeVec3d((double)((Float)this.field_70180_af.func_187225_a(WatchedFloat.hitX.key)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(WatchedFloat.hitY.key)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(WatchedFloat.hitZ.key)).floatValue());
    }

    public ForgeVec3d getLauncherPosition() {
        return HookShot.getCenterPosition((Entity)this.getThrower());
    }

    public ForgeVec3d getLauncherPosition(float tickProgress) {
        return HookShot.getCenterPosition((Entity)this.getThrower(), (float)tickProgress);
    }

    public void setHitPosition(ForgeVec3d hitPosition) {
        if (hitPosition != null) {
            this.field_70180_af.func_187227_b(WatchedFloat.hitX.key, (Object)Float.valueOf((float)hitPosition.x));
            this.field_70180_af.func_187227_b(WatchedFloat.hitY.key, (Object)Float.valueOf((float)hitPosition.y));
            this.field_70180_af.func_187227_b(WatchedFloat.hitZ.key, (Object)Float.valueOf((float)hitPosition.z));
        }
    }

    public boolean isHookingBlock() {
        return this.getState() == State.hookingBlock;
    }

    public boolean isHookingEntity() {
        return this.getState() == State.hookingEntity;
    }

    public boolean launcherInMainHand() {
        ItemStack itemStack = this.getThrower() != null ? this.getThrower().func_184614_ca() : null;
        return itemStack != null && itemStack.func_77973_b() instanceof HookLauncher && HookLauncher.isAttachedToHookShot(itemStack, this);
    }

    public BlockPos getHookedBlockPos() {
        return new BlockPos(((Integer)this.field_70180_af.func_187225_a(WatchedInt.hookedBlockX.key)).intValue(), ((Integer)this.field_70180_af.func_187225_a(WatchedInt.hookedBlockY.key)).intValue(), ((Integer)this.field_70180_af.func_187225_a(WatchedInt.hookedBlockZ.key)).intValue());
    }

    public void setHookedBlockPos(RayTraceResult rayTraceResult) {
        if (rayTraceResult != null && rayTraceResult.func_178782_a() != null) {
            this.field_70180_af.func_187227_b(WatchedInt.hookedBlockX.key, (Object)rayTraceResult.func_178782_a().func_177958_n());
            this.field_70180_af.func_187227_b(WatchedInt.hookedBlockY.key, (Object)rayTraceResult.func_178782_a().func_177956_o());
            this.field_70180_af.func_187227_b(WatchedInt.hookedBlockZ.key, (Object)rayTraceResult.func_178782_a().func_177952_p());
        }
    }

    protected void onTargetHit(RayTraceResult rayTraceResult) {
        if (rayTraceResult == null) {
            return;
        }
        if (this.getState() == State.reeling && !this.canHookOnReeling()) {
            return;
        }
        ForgeVec3d hitPosition = new ForgeVec3d(rayTraceResult.field_72307_f);
        switch (rayTraceResult.field_72313_a) {
            case BLOCK: {
                if (!this.canHookBlocks()) {
                    this.setState(State.reeling);
                    return;
                }
                this.setHookedBlockPos(rayTraceResult);
                this.setHitPosition(hitPosition);
                this.setState(State.hookingBlock);
                break;
            }
            case ENTITY: {
                IEntityMultiPart dragon;
                Entity target = rayTraceResult.field_72308_g;
                if (target instanceof EntityDragonPart && (dragon = ((EntityDragonPart)target).field_70259_a) instanceof Entity) {
                    target = (Entity)dragon;
                }
                if (target == null) break;
                Hook hook = this.getHookType().hook;
                if (hook != null && this.getThrower() != null && hook.damage > 0.0f) {
                    DamageSource damageSource = new EntityDamageSourceIndirect("arrow", (Entity)this, (Entity)this.getThrower()).func_76349_b();
                    target.func_70097_a(damageSource, hook.damage);
                }
                if (!this.canHookEntities()) {
                    this.setState(State.reeling);
                    return;
                }
                this.field_70180_af.func_187227_b(WatchedInt.hookedEntityId.key, (Object)target.func_145782_y());
                this.setState(State.hookingEntity);
                break;
            }
            default: {
                return;
            }
        }
        float ropeLength = (float)(this.getLauncherPosition().getDistance(hitPosition) + (double)this.getHookType().launcher.reelingSpeed);
        this.setRopeLength(ropeLength);
        this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
    }

    public void updatePhysics() {
        if (!this.isServerSide()) {
            return;
        }
        HookType hookType = this.getHookType();
        EntityLivingBase shooter = this.getThrower();
        if (shooter == null || shooter.field_70128_L || hookType.launcher == null || hookType.hook == null || hookType.rope == null || this.isServerSide() && shooter instanceof EntityPlayer && HookLauncher.findAttachedLauncher(((EntityPlayer)shooter).field_71071_by, this) == null) {
            this.func_70106_y();
            return;
        }
        State state = this.getState();
        ForgeVec3d launcherPosition = this.getLauncherPosition();
        ForgeVec3d tensionVec = ForgeVec3d.getZero();
        float tensionForce = 0.0f;
        float hookDistance = this.getHookDistance();
        float ropeMaxLength = hookType.rope.maxLength;
        float ropeLength = this.getRopeLength();
        float ropeMinLength = Math.min(shooter.field_70130_N, shooter.field_70131_O);
        float reelingSpeed = hookType.launcher.reelingSpeed;
        switch (state) {
            case shooting: {
                ropeLength = hookDistance + reelingSpeed;
                if (!(ropeLength > ropeMaxLength)) break;
                state = State.reeling;
                break;
            }
            case reeling: {
                ForgeVec3d motionVec = launcherPosition.subtract(this.getPositionVec()).normalize().scale((double)(reelingSpeed * 3.0f));
                this.setMotion(motionVec);
                float hookNextDistance = (float)launcherPosition.getDistance(this.getNextPosition());
                ropeLength = hookDistance;
                if (!(ropeLength <= ropeMinLength) && !(hookDistance <= hookNextDistance)) break;
                this.func_70106_y();
                break;
            }
            case hookingBlock: 
            case hookingEntity: {
                if (!(ropeLength < hookDistance)) break;
                tensionForce = hookType.rope.getTensionForce(ropeLength, hookDistance);
                tensionVec = this.getPositionVec().subtract(launcherPosition).normalize().scale((double)tensionForce);
                if (tensionForce > hookType.hook.strength) {
                    state = State.reeling;
                    break;
                }
                shooter.field_70143_R = 0.0f;
                if (!shooter.func_184218_aH()) break;
                List passengers = shooter.func_184208_bv().func_184188_bt();
                for (Entity entity : passengers) {
                    entity.field_70143_R = 0.0f;
                }
                break;
            }
        }
        switch (state) {
            case hookingBlock: {
                this.sendMotion((Entity)shooter, MotionMsg.Type.add, tensionVec, true);
                break;
            }
            case hookingEntity: {
                Entity target = this.getHookedEntity();
                if (target == null) break;
                float shooterWeight = ForgeEntity.getWeight((Entity)shooter) * 1.5f;
                float targetWeight = ForgeEntity.getWeight((Entity)target);
                float totalWeight = shooterWeight + targetWeight;
                ropeMinLength = (Math.max(shooter.field_70130_N, shooter.field_70131_O) + Math.max(target.field_70130_N, target.field_70131_O)) / 2.0f;
                if (totalWeight == 0.0f) {
                    totalWeight = 1.0f;
                }
                if (ropeLength <= hookDistance) {
                    target.field_70143_R = 0.0f;
                    if (target.func_184218_aH()) {
                        List passengers = target.func_184208_bv().func_184188_bt();
                        for (Entity entity : passengers) {
                            entity.field_70143_R = 0.0f;
                        }
                    }
                }
                if (hookType == HookType.pudge && ropeLength <= ropeMinLength) {
                    this.sendMotion(target, MotionMsg.Type.set, ForgeVec3d.getZero(), true);
                    this.func_70106_y();
                    break;
                }
                ForgeVec3d motionVec = tensionVec.invert().scale((double)(shooterWeight / totalWeight));
                this.sendMotion(target, MotionMsg.Type.add, motionVec, true);
                motionVec = tensionVec.scale((double)(targetWeight / totalWeight));
                this.sendMotion((Entity)shooter, MotionMsg.Type.add, motionVec, true);
                break;
            }
        }
        ropeLength = CommonMath.getInRange((float)ropeLength, (float)ropeMinLength, (float)ropeMaxLength);
        this.setRopeLength(ropeLength);
        this.setSagging(ropeLength - hookDistance);
        this.setState(state);
        this.setTensionForce(tensionForce);
    }

    protected void setTensionForce(float tensionForce) {
        this.field_70180_af.func_187227_b(WatchedFloat.tensionForce.key, (Object)Float.valueOf(tensionForce));
    }

    public float getHookDistance() {
        return (float)this.getLauncherPosition().getDistance(this.getPositionVec());
    }

    public void updateControlling() {
        if (!this.isServerSide()) {
            return;
        }
        HookType hookType = this.getHookType();
        EntityLivingBase shooter = this.getThrower();
        if (!this.launcherInMainHand() || hookType == null || hookType.launcher == null || shooter == null) {
            return;
        }
        boolean isPulling = this.getIsPulling();
        boolean isLoosening = this.getIsLoosening();
        float ropeLength = this.getRopeLength();
        float pullingSpeed = hookType.launcher.reelingSpeed * (shooter.func_70093_af() ? 0.5f : 1.0f);
        if (isPulling) {
            ropeLength -= pullingSpeed;
        }
        if (isLoosening) {
            ropeLength += pullingSpeed;
        }
        switch (this.getState()) {
            case hookingBlock: {
                if (!shooter.func_70051_ag() || !CommonMath.notZero((double)this.getTensionForce())) break;
                ropeLength += pullingSpeed;
                break;
            }
            case hookingEntity: {
                if (hookType != HookType.pudge || isLoosening) break;
                ropeLength -= pullingSpeed * 2.0f;
                break;
            }
        }
        this.setRopeLength(ropeLength);
    }

    @Nullable
    public Rope getRope() {
        HookType hookType = this.getHookType();
        return hookType != null ? hookType.rope : null;
    }

    @Nullable
    public HookLauncher getLauncher() {
        HookType hookType = this.getHookType();
        return hookType != null ? hookType.launcher : null;
    }

    @Nullable
    public Hook getHook() {
        HookType hookType = this.getHookType();
        return hookType != null ? hookType.hook : null;
    }

    public void sendMotion(Entity target, MotionMsg.Type type, ForgeVec3d motion, boolean reduction) {
        if (this.isServerSide() && target != null && type != null && motion != null) {
            if (target.func_184218_aH()) {
                target = target.func_184208_bv();
            }
            if (reduction) {
                ForgeVec3d lastAddedMotion = this.lastAddedMotionsList.getOrDefault(target, ForgeVec3d.getZero());
                if (type == MotionMsg.Type.add) {
                    this.lastAddedMotionsList.put(target, motion);
                    if (lastAddedMotion.isZero() && motion.getLength() < 1.0E-4) {
                        return;
                    }
                    Rope rope = this.getRope();
                    float motionReduction = rope != null ? rope.getMotionReduction() : 0.0f;
                    motion = motion.subtract(lastAddedMotion.scale((double)motionReduction));
                }
            }
            if (target instanceof EntityPlayer) {
                MotionMsg motionMsg = new MotionMsg(target, type, motion);
                ForgeMain.registrator.networkChannel.sendTo((IMessage)motionMsg, (EntityPlayerMP)target);
            } else {
                switch (type) {
                    case add: {
                        ForgeEntity.addMotion((Entity)target, (ForgeVec3d)motion);
                        break;
                    }
                    case set: {
                        ForgeEntity.setMotion((Entity)target, (ForgeVec3d)motion);
                    }
                }
            }
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.func_70106_y();
    }

    public boolean func_70067_L() {
        return false;
    }

    public EntityLivingBase getThrower() {
        Entity entity = ForgeWorld.findEntity((World)this.field_70170_p, (int)((Integer)this.field_70180_af.func_187225_a(WatchedInt.shooterId.key)));
        return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.field_70180_af.func_187227_b(WatchedInt.shooterId.key, (Object)ForgeEntity.getId((Entity)entity));
        }
    }

    public Block getHookedBlock() {
        return ForgeBlock.getBlock((World)this.field_70170_p, (BlockPos)this.getHookedBlockPos());
    }

    public boolean hookedBlockExists() {
        return !this.getHookedBlock().equals(Blocks.field_150350_a);
    }

    @Nullable
    public Entity getHookedEntity() {
        return HookShot.findEntity((World)this.field_70170_p, (int)((Integer)this.field_70180_af.func_187225_a(WatchedInt.hookedEntityId.key)));
    }

    public boolean hookedEntityIsAlive() {
        Entity entity = this.getHookedEntity();
        return entity != null && entity.func_70089_S();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updatePositionAndRotation();
        this.updatePhysics();
        this.updateCollisions();
        this.updateControlling();
        this.updateTargetState();
    }

    public void updateCollisions() {
        State state = this.getState();
        switch (state) {
            case shooting: 
            case reeling: {
                ArrayList<RayTraceResult> rayTraceResultsList = new ArrayList<RayTraceResult>();
                if (this.field_70170_p != null) {
                    rayTraceResultsList.add(this.field_70170_p.func_147447_a(this.getPositionVec().toVec3(), this.getNextPosition().toVec3(), false, true, false));
                }
                AxisAlignedBB aaBB = this.getBB().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                ArrayList list = this.getEntitiesWithinAABB(aaBB);
                EntityLivingBase shooter = this.getThrower();
                Entity shooterRide = shooter != null ? shooter.func_184187_bx() : null;
                for (Entity target : list) {
                    RayTraceResult rayTraceResult;
                    if (target == shooter && state == State.reeling) {
                        this.func_70106_y();
                        return;
                    }
                    if (!this.isServerSide() || !target.func_70067_L() || target == shooter || target == shooterRide || (rayTraceResult = HookShot.getBB((Entity)target).func_72327_a(this.getPositionVec().toVec3(), this.getNextPosition().toVec3())) == null) continue;
                    rayTraceResultsList.add(new RayTraceResult(target, HookShot.getCenterPosition((Entity)target).toVec3()));
                }
                if (!this.isServerSide()) break;
                RayTraceResult nearestResult = null;
                double minDistance = Double.MAX_VALUE;
                for (RayTraceResult rayTraceResult : rayTraceResultsList) {
                    double distance;
                    if (rayTraceResult == null || !((distance = this.getPositionVec().getDistance(new ForgeVec3d(rayTraceResult.field_72307_f))) < minDistance)) continue;
                    nearestResult = rayTraceResult;
                    minDistance = distance;
                }
                if (nearestResult == null) break;
                this.onTargetHit(nearestResult);
                break;
            }
        }
    }

    public void updateTargetState() {
        if (!this.isServerSide()) {
            return;
        }
        switch (this.getState()) {
            case hookingBlock: {
                if (this.hookedBlockExists()) break;
                this.setState(State.reeling);
                break;
            }
            case hookingEntity: {
                Entity entity = this.getHookedEntity();
                if (entity == null || entity.field_70128_L || entity instanceof EntityLivingBase && ((EntityLivingBase)entity).field_82175_bq && entity.func_70093_af() || entity instanceof EntityPlayer && entity.func_184218_aH() && ((EntityPlayer)entity).field_82175_bq || HookShot.hasSwingingPlayerPassenger((Entity)entity)) {
                    this.setState(State.reeling);
                    break;
                }
                this.setHitPosition(ForgeEntity.getCenterPosition((Entity)entity));
                break;
            }
        }
    }

    public void updatePositionAndRotation() {
        State state = this.getState();
        switch (state) {
            case hookingBlock: 
            case hookingEntity: {
                ForgeVec3d toHitPos = this.getHitPosition().subtract(this.getPositionVec());
                this.setMotion(toHitPos);
                this.field_70122_E = true;
                break;
            }
            default: {
                this.field_70122_E = false;
                ForgeVec3d motion = this.getMotion();
                if (this.isClientSide() && motion.notZero() && state == State.reeling) {
                    motion = motion.invert();
                    if (this.getPrevState() == State.shooting) {
                        this.setAllRotations(motion.getRotationWrapped());
                    } else {
                        this.setRotation(motion.getRotationWrapped());
                    }
                }
                double motionFactor = 0.99f;
                if (this.func_70090_H()) {
                    ForgeVec3d bubblePos = this.getPositionVec().subtract(this.getMotion().scale(0.25));
                    for (int i = 0; i < 4; ++i) {
                        ForgeWorld.spawnParticle((World)this.field_70170_p, (EnumParticleTypes)EnumParticleTypes.WATER_BUBBLE, (ForgeVec3d)bubblePos, (ForgeVec3d)this.getMotion());
                    }
                    motionFactor = 0.8f;
                }
                this.setMotion(this.getMotion().scale(motionFactor));
                this.field_70181_x -= (double)0.005f;
            }
        }
        this.setPosition(this.getPositionVec().add(this.getMotion()));
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        ForgeVec3d vec = new ForgeVec3d(x, y, z).normalize().scale((double)velocity);
        Rotation rotation = new Rotation(vec.getPitch(), vec.getYaw());
        this.setMotion(vec);
        this.setAllRotations(rotation);
    }

    public void func_70106_y() {
        InventoryPlayer inventory;
        ItemStack launcher;
        if (this.getThrower() instanceof EntityPlayer && (launcher = HookLauncher.findAttachedLauncher(inventory = ((EntityPlayer)this.getThrower()).field_71071_by, this)) != null) {
            HookLauncher.unattach(launcher);
        }
        super.func_70106_y();
    }

    public float getTensionForce() {
        return ((Float)this.field_70180_af.func_187225_a(WatchedFloat.tensionForce.key)).floatValue();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < (double)(RENDER_DISTANCE * RENDER_DISTANCE);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.getBB().func_111270_a(HookShot.getBB((Entity)this.getThrower()));
    }

    public void boostUpShooter() {
        EntityLivingBase shooter = this.getThrower();
        HookLauncher launcher = this.getLauncher();
        if (shooter != null && launcher != null) {
            ForgeVec3d motion = new ForgeVec3d(0.0, (double)launcher.reelingSpeed, 0.0);
            this.sendMotion((Entity)shooter, MotionMsg.Type.add, motion, false);
        }
    }

    public static enum State {
        shooting,
        reeling,
        hookingBlock,
        hookingEntity;

    }

    public static enum WatchedFloat {
        hitX,
        hitY,
        hitZ,
        ropeLength,
        sagging,
        tensionForce;

        public final DataParameter<Float> key = EntityDataManager.func_187226_a(HookShot.class, (DataSerializer)DataSerializers.field_187193_c);
    }

    public static enum WatchedInt {
        hookedBlockX,
        hookedBlockY,
        hookedBlockZ,
        hookedEntityId,
        hookType,
        prevState,
        shooterId,
        state;

        public final DataParameter<Integer> key = EntityDataManager.func_187226_a(HookShot.class, (DataSerializer)DataSerializers.field_187192_b);
    }

    public static enum WatchedBool {
        isPulling,
        isLoosening;

        public final DataParameter<Boolean> key = EntityDataManager.func_187226_a(HookShot.class, (DataSerializer)DataSerializers.field_187198_h);
    }
}

