/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.shot;

import com.endertech.common.CommonMath;
import com.endertech.common.CommonString;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeLocating;
import com.endertech.minecraft.forge.ForgeRendering;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.entities.Rotation;
import com.endertech.minecraft.forge.math.ForgeVec3d;
import com.endertech.minecraft.mods.adhooks.Rope;
import com.endertech.minecraft.mods.adhooks.init.HookType;
import com.endertech.minecraft.mods.adhooks.shot.HookShot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class HookShotRender
extends Render<HookShot> {
    public HookShotRender(RenderManager renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(HookType hookType, String namePostfix) {
        String name = (hookType != null && hookType.hook != null ? hookType.hook.getId().unitName : "null") + (CommonString.isNullOrEmpty((String)namePostfix) ? "" : "_" + namePostfix);
        return ForgeLocating.itemTexture((String)"AdHooks", (String)name, (String[])new String[0]);
    }

    public ResourceLocation getTextureLocation(HookType hookType) {
        return this.getTextureLocation(hookType, "");
    }

    public ResourceLocation getBackTextureLocation(HookType hookType) {
        return this.getTextureLocation(hookType, "back");
    }

    public void renderShot(HookShot hookShot, double x, double y, double z, float alpha, float tickProgress) {
        if (hookShot == null || hookShot.getHookType() == null) {
            return;
        }
        HookType hookType = hookShot.getHookType();
        Rotation shotRotation = hookShot.getRotation(tickProgress);
        float hookThickness = 0.0625f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(shotRotation.yaw - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)shotRotation.pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        switch (hookType) {
            case web: {
                this.func_110776_a(this.getBackTextureLocation(hookType));
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            default: {
                this.func_110776_a(this.getTextureLocation(hookType));
                GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        double scale = 0.5;
        GlStateManager.func_179091_B();
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        switch (hookType) {
            case web: {
                GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)(hookThickness / 2.0f));
                break;
            }
            default: {
                GlStateManager.func_179137_b((double)-0.1, (double)-0.9, (double)(hookThickness / 2.0f));
            }
        }
        if (hookType.hook != null) {
            ForgeRendering.renderItemLayerIn2D((int)16, (int)16, (float)hookThickness, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (double)0.0, (double)0.0, (double)0.0);
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public void renderRope(HookShot hookShot, double x, double y, double z, float rotationYaw, float tickProgress) {
        boolean shooterIsMe;
        if (hookShot == null) {
            return;
        }
        EntityLivingBase shooter = hookShot.getThrower();
        if (shooter == null) {
            return;
        }
        ForgeVec3d launcherOffset = ForgeVec3d.getZero();
        Rotation shooterRotation = ForgeEntity.getRotation((Entity)shooter, (float)tickProgress);
        boolean bl = shooterIsMe = shooter == Minecraft.func_71410_x().field_71439_g;
        if (shooterIsMe) {
            switch (this.field_76990_c.field_78733_k.field_74320_O) {
                case 1: 
                case 2: {
                    launcherOffset = new ForgeVec3d(-0.1, 0.0, 0.0);
                    break;
                }
                default: {
                    launcherOffset = new ForgeVec3d(-0.6, -0.6, 0.0);
                }
            }
        }
        launcherOffset = launcherOffset.rotateAroundX(-shooterRotation.pitch).rotateAroundY(-shooterRotation.yaw);
        ForgeVec3d launcherPos = hookShot.getLauncherPosition(tickProgress).add(launcherOffset);
        ForgeVec3d hookShotPos = hookShot.getPosition(tickProgress);
        ForgeVec3d ropeVec = launcherPos.subtract(hookShotPos);
        HookType hookType = hookShot.getHookType();
        if (hookType.rope != null) {
            Rope rope = hookType.rope;
            float hookStrength = hookType.hook != null ? hookType.hook.strength : 0.0f;
            float tensionForce = hookShot.getTensionForce();
            float tensionFactor = CommonMath.notZero((double)hookStrength) && CommonMath.notZero((double)rope.elasticity) ? tensionForce / hookStrength : 0.0f;
            float ropeWidth = CommonMath.getApproxDown((float)tensionFactor, (FloatBounds)new FloatBounds(Rope.WIDTH_BOUNDS.min, shooterIsMe ? rope.width : 4.0f));
            float sagging = hookShot.getSagging();
            ForgeVec3d viewPos = new ForgeVec3d(this.field_76990_c.field_78730_l, this.field_76990_c.field_78731_m, this.field_76990_c.field_78728_n);
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179129_p();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GL11.glEnable((int)2848);
            if (rope.color != null) {
                GlStateManager.func_179124_c((float)rope.color.getRedF(), (float)rope.color.getGreenF(), (float)rope.color.getBlueF());
            }
            ForgeVec3d fromPoint = ForgeVec3d.getZero();
            for (int i = 1; i <= rope.segmentsAmount; ++i) {
                float f = i;
                rope.getClass();
                float ropeProgress = f / 16.0f;
                float sagHeight = MathHelper.func_76126_a((float)(ropeProgress * (float)Math.PI)) * sagging;
                ForgeVec3d toPoint = new ForgeVec3d(ropeVec.x * (double)ropeProgress, ropeVec.y * (double)ropeProgress - (double)sagHeight, ropeVec.z * (double)ropeProgress);
                float viewDistance = (float)viewPos.getDistance(hookShotPos.add(toPoint));
                float scale = CommonMath.notZero((double)viewDistance) ? 10.0f / viewDistance : 1.0f;
                float ropeWidthScaled = CommonMath.getStrictApproxUp((float)scale, (FloatBounds)new FloatBounds(Rope.WIDTH_BOUNDS.min, ropeWidth));
                GlStateManager.func_187441_d((float)ropeWidthScaled);
                GlStateManager.func_187447_r((int)1);
                GL11.glVertex3d((double)fromPoint.x, (double)fromPoint.y, (double)fromPoint.z);
                GL11.glVertex3d((double)toPoint.x, (double)toPoint.y, (double)toPoint.z);
                GlStateManager.func_187437_J();
                fromPoint = toPoint;
            }
            GL11.glDisable((int)2848);
            GlStateManager.func_179117_G();
            GlStateManager.func_179089_o();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }
    }

    public void doRender(HookShot hookShot, double x, double y, double z, float yaw, float tickProgress) {
        if (hookShot.getState() != HookShot.State.hookingEntity) {
            this.renderShot(hookShot, x, y, z, yaw, tickProgress);
        }
        this.renderRope(hookShot, x, y, z, yaw, tickProgress);
        super.func_76986_a((Entity)hookShot, x, y, z, yaw, tickProgress);
    }

    protected ResourceLocation getEntityTexture(HookShot entity) {
        return null;
    }

    public boolean func_188295_H_() {
        return false;
    }
}

