/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.common;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import java.util.Random;

public abstract class CommonMath {
    public static final double ALMOST_ZERO = 1.0E-4;
    public static final Random random = new Random();

    public static boolean notZero(double value) {
        return Math.abs(value) >= 1.0E-4;
    }

    public static float getApprox(float factor, FloatBounds bounds, ApproxType type) {
        if (bounds != null) {
            switch (type) {
                case BOTTOM_UP: {
                    return bounds.min + (bounds.max - bounds.min) * factor;
                }
                case TOP_DOWN: {
                    return bounds.max - (bounds.max - bounds.min) * factor;
                }
            }
        }
        return 0.0f;
    }

    public static float getApproxUp(float factor, FloatBounds bounds) {
        return CommonMath.getApprox(factor, bounds, ApproxType.BOTTOM_UP);
    }

    public static float getApproxDown(float factor, FloatBounds bounds) {
        return CommonMath.getApprox(factor, bounds, ApproxType.TOP_DOWN);
    }

    public static int getApprox(float factor, IntBounds bounds, ApproxType type) {
        if (bounds != null) {
            switch (type) {
                case BOTTOM_UP: {
                    return CommonMath.getRounded((float)bounds.min + (float)(bounds.max - bounds.min) * factor);
                }
                case TOP_DOWN: {
                    return CommonMath.getRounded((float)bounds.max - (float)(bounds.max - bounds.min) * factor);
                }
            }
        }
        return 0;
    }

    public static int getApproxUp(float factor, IntBounds bounds) {
        return CommonMath.getApprox(factor, bounds, ApproxType.BOTTOM_UP);
    }

    public static int getApproxDown(float factor, IntBounds bounds) {
        return CommonMath.getApprox(factor, bounds, ApproxType.TOP_DOWN);
    }

    public static float getStrictApproxUp(float factor, FloatBounds bounds) {
        return CommonMath.getInRange(CommonMath.getApproxUp(factor, bounds), bounds);
    }

    public static int getStrictApproxUp(float factor, IntBounds bounds) {
        return CommonMath.getInRange(CommonMath.getApproxUp(factor, bounds), bounds);
    }

    public static float getStrictApproxDown(float factor, FloatBounds bounds) {
        return CommonMath.getInRange(CommonMath.getApproxDown(factor, bounds), bounds);
    }

    public static int getStrictApproxDown(float factor, IntBounds bounds) {
        return CommonMath.getInRange(CommonMath.getApproxDown(factor, bounds), bounds);
    }

    public static double getAverage(double a, double b) {
        return (a + b) / 2.0;
    }

    public static double getAverage(double a, double b, double c) {
        return (a + b + c) / 3.0;
    }

    public static double getInRange(double value, double bound1, double bound2) {
        double min = Math.min(bound1, bound2);
        double max = Math.max(bound1, bound2);
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static float getInRange(float value, float bound1, float bound2) {
        float min = Math.min(bound1, bound2);
        float max = Math.max(bound1, bound2);
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static float getInRange(float value, FloatBounds bounds) {
        if (bounds != null) {
            return CommonMath.getInRange(value, bounds.min, bounds.max);
        }
        return value;
    }

    public static int getInRange(int value, int bound1, int bound2) {
        int min = Math.min(bound1, bound2);
        int max = Math.max(bound1, bound2);
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static int getInRange(int value, IntBounds bounds) {
        if (bounds != null) {
            return CommonMath.getInRange(value, bounds.min, bounds.max);
        }
        return value;
    }

    public static int getRandom(int minValue, int maxValue) {
        return minValue < maxValue ? random.nextInt(maxValue - minValue + 1) + minValue : minValue;
    }

    public static int getRandom(IntBounds bounds) {
        bounds = IntBounds.getFixed(bounds);
        return CommonMath.getRandom(bounds.min, bounds.max);
    }

    public static float getRandom(float minValue, float maxValue) {
        return minValue < maxValue ? random.nextFloat() * (maxValue - minValue) + minValue : minValue;
    }

    public static float getRandom(FloatBounds bounds) {
        bounds = FloatBounds.getFixed(bounds);
        return CommonMath.getRandom(bounds.min, bounds.max);
    }

    public static double getRandom(double minValue, double maxValue) {
        return minValue < maxValue ? random.nextDouble() * (maxValue - minValue) + minValue : minValue;
    }

    public static boolean getResult(float probability) {
        return random.nextFloat() < probability;
    }

    public static long getRounded(double a) {
        return Math.round(a);
    }

    public static int getRounded(float a) {
        return Math.round(a);
    }

    public static double raiseToPower(double value, double power) {
        return Math.pow(value, power);
    }

    public static double getMinByAbs(double a, double b) {
        if (Math.abs(a) <= Math.abs(b)) {
            return a;
        }
        return b;
    }

    public static double getMaxByAbs(double a, double b) {
        if (Math.abs(a) <= Math.abs(b)) {
            return a;
        }
        return b;
    }

    public static double getDegrees(double radians) {
        return radians * 180.0 / Math.PI;
    }

    public static double getRadians(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    public static enum ApproxType {
        BOTTOM_UP,
        TOP_DOWN;

    }
}

