/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;

public enum ForgeBounds {
    blockId(Integer.MIN_VALUE, Integer.MAX_VALUE),
    blockHardness(-1, 100),
    blockResistance(-1, 320),
    dimensionId(Integer.MIN_VALUE, Integer.MAX_VALUE),
    dispersion(0, 1),
    experience(0, 256),
    frequency(0, 1),
    hardness(0, 10),
    harvestLevel(-1, 3),
    harvestXP(0, 7),
    height(0, 256),
    lightLevel(0, 1),
    magicability(0, 1),
    oreY(0, 128),
    oreBlocksInVein(1, 12),
    oreVeinsInChunk(1, 32),
    resistance(0, 32),
    smeltingXP(0, 7),
    stability(0, 1),
    stackSize(0, 64),
    strength(0, 1);

    public final IntBounds INT;
    public final FloatBounds FLOAT;

    private ForgeBounds(int min, int max) {
        this.INT = new IntBounds(min, max);
        this.FLOAT = new FloatBounds(min, max);
    }

    private ForgeBounds(float min, float max) {
        this.FLOAT = new FloatBounds(min, max);
        this.INT = new IntBounds((int)min, (int)max);
    }

    public static float FloatApproxUp(float factor, ForgeBounds bounds) {
        if (bounds != null) {
            return CommonMath.getStrictApproxUp(factor, bounds.FLOAT);
        }
        return 0.0f;
    }

    public static float FloatApproxDown(float factor, ForgeBounds bounds) {
        if (bounds != null) {
            return CommonMath.getStrictApproxDown(factor, bounds.FLOAT);
        }
        return 0.0f;
    }

    public static int IntApproxUp(float factor, ForgeBounds bounds) {
        if (bounds != null) {
            return CommonMath.getStrictApproxUp(factor, bounds.INT);
        }
        return 0;
    }
}

