/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.configs;

import com.endertech.common.Args;
import com.endertech.common.Console;
import java.awt.Color;

public class ColorARGB {
    public static final int MAX_BYTE_VALUE = 255;
    public static final ColorARGB DEFAULT = new ColorARGB(0);
    public static final String HEX_FORMAT = "ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)";
    public static final String DESCRIPTION_COMMON = "Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)";
    public static final String DESCRIPTION_FOR_SMOKE = "Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb) which will be applied to the smoke.\nThe alpha channel of this color (aa) determines probability of applying (ff - always, 7f - 1/2, 00 - never).";
    public final Color color;

    public ColorARGB() {
        this(0);
    }

    public ColorARGB(int intARGB) {
        this.color = new Color(intARGB, true);
    }

    public ColorARGB(String hexARGB) {
        this(ColorARGB.getARGB(hexARGB));
    }

    public static int getARGB(String hexARGB) {
        hexARGB = hexARGB.toLowerCase().trim();
        int offset = 0;
        if (hexARGB.startsWith("#")) {
            offset = 1;
        }
        if (hexARGB.startsWith("0x")) {
            offset = 2;
        }
        int argb = 0;
        try {
            argb = Integer.parseUnsignedInt(hexARGB.substring(offset), 16);
        }
        catch (NumberFormatException e) {
            Console.msgError("'%s' is not a valid hex ARGBcolor representation!", hexARGB);
            Console.msgDebug(e.toString());
        }
        return argb;
    }

    public static String getHexARGB(int intARGB) {
        return String.format("%#010x", intARGB);
    }

    public int getAlpha() {
        return this.color.getAlpha();
    }

    public float getAlphaF() {
        return (float)this.getAlpha() / 255.0f;
    }

    public int getRed() {
        return this.color.getRed();
    }

    public float getRedF() {
        return (float)this.getRed() / 255.0f;
    }

    public int getGreen() {
        return this.color.getGreen();
    }

    public float getGreenF() {
        return (float)this.getGreen() / 255.0f;
    }

    public int getBlue() {
        return this.color.getBlue();
    }

    public float getBlueF() {
        return (float)this.getBlue() / 255.0f;
    }

    public int getARGB() {
        return this.color.getRGB();
    }

    public String toString() {
        return this.getClass().getSimpleName() + Args.group(Args.get("a", this.getAlpha()), Args.get("r", this.getRed()), Args.get("g", this.getGreen()), Args.get("b", this.getBlue()));
    }

    public String getHexARGB() {
        return ColorARGB.getHexARGB(this.getARGB());
    }

    public boolean isOpaque() {
        return this.getAlpha() == 255;
    }

    public boolean isCompletelyTransparent() {
        return this.getAlpha() == 0;
    }
}

