/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.configs;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.common.Console;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import java.io.File;
import java.nio.file.Path;
import net.minecraftforge.common.config.Configuration;

public class ForgeConfig
extends Configuration {
    public static final String EXTENSION = ".cfg";
    public static final String KEY_LIST = "list";

    public static String getDescription(String param, String description, boolean addCR) {
        return param + " " + description + (addCR ? "\n" : "");
    }

    public static String getSyntax(Object ... args) {
        return "Syntax: " + Args.join(args);
    }

    public ForgeConfig(File file) {
        super(file, true);
        this.load();
    }

    public static boolean getBool(ForgeConfig config, String category, String key, boolean defaultValue, String comment) {
        if (config != null && category != null && key != null) {
            return config.getBool(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static int getInt(ForgeConfig config, String category, String key, int defaultValue, IntBounds bounds, String comment) {
        if (config != null && category != null && key != null) {
            return config.getInt(category, key, defaultValue, bounds, comment);
        }
        return CommonMath.getInRange(defaultValue, bounds);
    }

    public static float getFloat(ForgeConfig config, String category, String key, float defaultValue, FloatBounds bounds, String comment) {
        if (config != null && category != null && key != null) {
            return config.getFloat(category, key, defaultValue, bounds, comment);
        }
        return CommonMath.getInRange(defaultValue, bounds);
    }

    public static String getStr(ForgeConfig config, String category, String key, String defaultValue, String comment) {
        if (config != null && category != null && key != null) {
            return config.getStr(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static String[] getStrArray(ForgeConfig config, String category, String key, String[] defaultValues, String comment) {
        if (config != null && category != null && key != null) {
            return config.getStrArray(category, key, defaultValues, comment);
        }
        return defaultValues;
    }

    public boolean getBool(String category, String key, boolean defaultValue, String comment) {
        try {
            return this.getBoolean(key, category, defaultValue, comment);
        }
        catch (Exception e) {
            Console.msgError(e.toString());
            return defaultValue;
        }
    }

    public int getInt(String category, String key, int defaultValue, IntBounds bounds, String comment) {
        try {
            return this.getInt(key, category, defaultValue, bounds.min, bounds.max, comment);
        }
        catch (Exception e) {
            Console.msgError(e.toString());
            return CommonMath.getInRange(defaultValue, bounds);
        }
    }

    public float getFloat(String category, String key, float defaultValue, FloatBounds bounds, String comment) {
        try {
            return this.getFloat(key, category, defaultValue, bounds.min, bounds.max, comment);
        }
        catch (Exception e) {
            Console.msgError(e.toString());
            return CommonMath.getInRange(defaultValue, bounds);
        }
    }

    public String getStr(String category, String key, String defaultValue, String comment) {
        try {
            return this.getString(key, category, defaultValue, comment);
        }
        catch (Exception e) {
            Console.msgError(e.toString());
            return defaultValue;
        }
    }

    public String[] getStrArray(String category, String key, String[] defaultValues, String comment) {
        try {
            return this.getStringList(key, category, defaultValues, comment);
        }
        catch (Exception e) {
            Console.msgError(e.toString());
            return defaultValues;
        }
    }

    public Path getConfigDir() {
        return this.getConfigFile().getParentFile().toPath();
    }
}

