/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.configs;

import com.endertech.minecraft.forge.math.ForgeVec3d;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public final class ForgeNBT {
    public static final String KEY_UUID_MOST = "M";
    public static final String KEY_UUID_LEAST = "L";
    public static final String KEY_VEC3_X = "X";
    public static final String KEY_VEC3_Y = "Y";
    public static final String KEY_VEC3_Z = "Z";

    @Nonnull
    public static NBTTagCompound getTag(NBTTagCompound compound, String key) {
        return compound != null && key != null ? compound.func_74775_l(key) : new NBTTagCompound();
    }

    public static boolean hasKey(NBTTagCompound compound, String key) {
        return compound != null && compound.func_74764_b(key);
    }

    public static void writeUUID(NBTTagCompound compound, String key, UUID uuid) {
        if (compound != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74772_a(KEY_UUID_MOST, uuid.getMostSignificantBits());
            tag.func_74772_a(KEY_UUID_LEAST, uuid.getLeastSignificantBits());
            compound.func_74782_a(key, (NBTBase)tag);
        }
    }

    public static UUID readUUID(NBTTagCompound compound, String key) {
        NBTTagCompound tag = ForgeNBT.getTag(compound, key);
        return new UUID(tag.func_74763_f(KEY_UUID_MOST), tag.func_74763_f(KEY_UUID_LEAST));
    }

    public static void writeVec3d(NBTTagCompound compound, String key, ForgeVec3d vec) {
        if (compound != null && vec != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a(KEY_VEC3_X, vec.x);
            tag.func_74780_a(KEY_VEC3_Y, vec.y);
            tag.func_74780_a(KEY_VEC3_Z, vec.z);
            compound.func_74782_a(key, (NBTBase)tag);
        }
    }

    public static ForgeVec3d readVec3d(NBTTagCompound compound, String key) {
        NBTTagCompound tag = ForgeNBT.getTag(compound, key);
        return new ForgeVec3d(tag.func_74769_h(KEY_VEC3_X), tag.func_74769_h(KEY_VEC3_Y), tag.func_74769_h(KEY_VEC3_Z));
    }

    public static void writeBlockPos(NBTTagCompound compound, String key, BlockPos pos) {
        if (compound != null && pos != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a(KEY_VEC3_X, (double)pos.func_177958_n());
            tag.func_74780_a(KEY_VEC3_Y, (double)pos.func_177956_o());
            tag.func_74780_a(KEY_VEC3_Z, (double)pos.func_177952_p());
            compound.func_74782_a(key, (NBTBase)tag);
        }
    }

    public static BlockPos readBlockPos(NBTTagCompound compound, String key) {
        NBTTagCompound tag = ForgeNBT.getTag(compound, key);
        return new BlockPos(tag.func_74762_e(KEY_VEC3_X), tag.func_74762_e(KEY_VEC3_Y), tag.func_74762_e(KEY_VEC3_Z));
    }

    @Nullable
    public static <T extends Enum<T>> T readEnumValue(NBTTagCompound compound, Class<T> enumClass) {
        if (compound != null && enumClass != null) {
            String name = compound.func_74779_i(enumClass.getSimpleName());
            return Enum.valueOf(enumClass, name);
        }
        return null;
    }

    public static <T extends Enum<T>> void writeEnumValue(NBTTagCompound compound, T enumValue) {
        if (compound != null && enumValue != null) {
            compound.func_74778_a(enumValue.getClass().getSimpleName(), enumValue.name());
        }
    }
}

