/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.configs;

import com.endertech.common.Console;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class UnitConfig
extends ForgeConfig {
    public UnitConfig(Path baseDir, String unitClassName, String unitName) {
        this(Paths.get(String.valueOf(baseDir), unitClassName), unitName);
    }

    public UnitConfig(Path baseDir, String configName) {
        this(Paths.get(String.valueOf(baseDir), configName + ".cfg").toFile());
    }

    public UnitConfig(File file) {
        super(file);
    }

    public static ArrayList<Path> listCustomConfigs(Path searchDir, Class<? extends Enum<?>> exclude) {
        ArrayList<String> excludeList = new ArrayList<String>();
        if (exclude != null) {
            for (Enum<?> e : exclude.getEnumConstants()) {
                excludeList.add(e.name() + ".cfg");
            }
        }
        ArrayList<Path> configList = new ArrayList<Path>();
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(searchDir, "*.cfg");){
            for (Path path : dirStream) {
                if (excludeList.contains(String.valueOf(path.getFileName()))) continue;
                configList.add(path);
            }
        }
        catch (Exception e) {
            Console.msgError(e.toString());
        }
        return configList;
    }
}

