/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.ForgeWorld;
import com.endertech.minecraft.forge.entities.Rotation;
import com.endertech.minecraft.forge.math.ForgeVec3d;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class ForgeEntity
extends Entity {
    public ForgeEntity(World world) {
        super(world);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tag) {
    }

    protected void func_70014_b(NBTTagCompound tag) {
    }

    public static ForgeVec3d getBBCenter(AxisAlignedBB bb) {
        if (bb != null) {
            return new ForgeVec3d(CommonMath.getAverage(bb.field_72340_a, bb.field_72336_d), CommonMath.getAverage(bb.field_72338_b, bb.field_72337_e), CommonMath.getAverage(bb.field_72339_c, bb.field_72334_f));
        }
        return ForgeVec3d.getZero();
    }

    public ForgeVec3d getBBCenter() {
        return ForgeEntity.getBBCenter(this.getBB());
    }

    public static ForgeVec3d getCenterPosition(Entity entity) {
        return ForgeEntity.getBBCenter(ForgeEntity.getBB(entity));
    }

    public static ForgeVec3d getCenterPosition(Entity entity, float tickProgress) {
        return ForgeEntity.getBBCenter(ForgeEntity.getBB(entity, ForgeEntity.getPosition(entity, tickProgress)));
    }

    public static Entity findEntity(World world, int id) {
        return world != null ? world.func_73045_a(id) : null;
    }

    public static void setCollisionReduction(Entity entity, float factor) {
        if (entity != null) {
            entity.field_70144_Y = factor;
        }
    }

    public static ForgeVec3d getMotion(Entity entity) {
        return entity != null ? new ForgeVec3d(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y) : ForgeVec3d.getZero();
    }

    public ForgeVec3d getMotion() {
        return ForgeEntity.getMotion(this);
    }

    public static void setMotion(Entity entity, ForgeVec3d vec) {
        if (entity != null && vec != null) {
            boolean motionChanged = ForgeEntity.getMotion(entity).notEqual(vec);
            entity.field_70159_w = vec.x;
            entity.field_70181_x = vec.y;
            entity.field_70179_y = vec.z;
            if (motionChanged) {
                entity.field_70133_I = true;
            }
        }
    }

    public void setMotion(ForgeVec3d vec) {
        ForgeEntity.setMotion(this, vec);
    }

    public static void addMotion(Entity entity, ForgeVec3d vec) {
        if (entity != null && vec != null) {
            ForgeEntity.setMotion(entity, ForgeEntity.getMotion(entity).add(vec));
        }
    }

    public void addMotion(ForgeVec3d vec) {
        ForgeEntity.addMotion(this, vec);
    }

    public static void copyAllPositions(Entity source, Entity target) {
        if (source != null && target != null) {
            ForgeEntity.setPrevPosition(target, ForgeEntity.getPrevPosition(source));
            ForgeEntity.setPosition(target, ForgeEntity.getPosition(source));
        }
    }

    public static ForgeVec3d getPosition(Entity entity) {
        return entity != null ? new ForgeVec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v) : ForgeVec3d.getZero();
    }

    public static ForgeVec3d getPosition(Entity entity, float tickProgress) {
        return ForgeVec3d.getApprox(tickProgress, ForgeEntity.getLastTickPosition(entity), ForgeEntity.getPosition(entity));
    }

    public ForgeVec3d getPositionVec() {
        return ForgeEntity.getPosition(this);
    }

    public ForgeVec3d getPosition(float tickProgress) {
        return ForgeEntity.getPosition(this, tickProgress);
    }

    public static Rotation getPrevRotation(Entity entity) {
        return entity != null ? new Rotation(entity.field_70127_C, entity.field_70126_B) : Rotation.getZero();
    }

    public static Rotation getRotation(Entity entity) {
        return entity != null ? new Rotation(entity.field_70125_A, entity.field_70177_z) : Rotation.getZero();
    }

    public static Rotation getRotation(Entity entity, float tickProgress) {
        return ForgeEntity.getPrevRotation(entity).approx(tickProgress, ForgeEntity.getRotation(entity));
    }

    public Rotation getRotation(float tickProgress) {
        return ForgeEntity.getRotation(this, tickProgress);
    }

    public Rotation getPrevRotation() {
        return ForgeEntity.getPrevRotation(this);
    }

    public Rotation getRotation() {
        return ForgeEntity.getRotation(this);
    }

    public static ForgeVec3d getLastTickPosition(Entity entity) {
        return entity != null ? new ForgeVec3d(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U) : ForgeVec3d.getZero();
    }

    public ForgeVec3d getLastTickPosition() {
        return ForgeEntity.getLastTickPosition(this);
    }

    public static ForgeVec3d getPrevPosition(Entity entity) {
        return entity != null ? new ForgeVec3d(entity.field_70169_q, entity.field_70167_r, entity.field_70166_s) : ForgeVec3d.getZero();
    }

    public ForgeVec3d getPrevPosition() {
        return ForgeEntity.getPrevPosition(this);
    }

    public static ForgeVec3d getNextPosition(Entity entity) {
        return entity != null ? ForgeEntity.getPosition(entity).add(ForgeEntity.getMotion(entity)) : ForgeVec3d.getZero();
    }

    public ForgeVec3d getNextPosition() {
        return ForgeEntity.getNextPosition(this);
    }

    public static void setPosition(Entity entity, ForgeVec3d vec) {
        ForgeEntity.setPrevPosition(entity, ForgeEntity.getPosition(entity));
        if (entity != null && vec != null) {
            entity.func_70107_b(vec.x, vec.y, vec.z);
        }
    }

    public static void setPosition_NoBB(Entity entity, ForgeVec3d vec) {
        if (entity != null && vec != null) {
            entity.field_70165_t = vec.x;
            entity.field_70163_u = vec.y;
            entity.field_70161_v = vec.z;
        }
    }

    public static void setLastTickPosition(Entity entity, ForgeVec3d vec) {
        if (entity != null && vec != null) {
            entity.field_70142_S = vec.x;
            entity.field_70137_T = vec.y;
            entity.field_70136_U = vec.z;
        }
    }

    public void setLastTickPosition(ForgeVec3d vec) {
        ForgeEntity.setLastTickPosition(this, vec);
    }

    public static void setPrevPosition(Entity entity, ForgeVec3d vec) {
        ForgeEntity.setLastTickPosition(entity, vec);
        if (entity != null && vec != null) {
            entity.field_70169_q = vec.x;
            entity.field_70167_r = vec.y;
            entity.field_70166_s = vec.z;
        }
    }

    public void setPrevPosition(ForgeVec3d vec) {
        ForgeEntity.setPrevPosition(this, vec);
    }

    public void setPosition(ForgeVec3d vec) {
        ForgeEntity.setPosition(this, vec);
    }

    public static void setPrevRotation(Entity entity, Rotation rotation) {
        if (entity != null && rotation != null) {
            entity.field_70127_C = rotation.pitch;
            entity.field_70126_B = rotation.yaw;
        }
    }

    public void setPrevRotation(Rotation rotation) {
        ForgeEntity.setPrevRotation(this, rotation);
    }

    public static void setRotation(Entity entity, Rotation rotation) {
        ForgeEntity.setPrevRotation(entity, ForgeEntity.getRotation(entity));
        if (entity != null && rotation != null) {
            entity.field_70125_A = rotation.pitch;
            entity.field_70177_z = rotation.yaw;
        }
    }

    public void setRotation(Rotation rotation) {
        ForgeEntity.setRotation(this, rotation);
    }

    public static void setAllPositions(Entity entity, ForgeVec3d vec) {
        if (entity != null && vec != null) {
            entity.field_70169_q = entity.field_70165_t = vec.x;
            entity.field_70142_S = entity.field_70165_t;
            entity.field_70167_r = entity.field_70163_u = vec.y;
            entity.field_70137_T = entity.field_70163_u;
            entity.field_70166_s = entity.field_70161_v = vec.z;
            entity.field_70136_U = entity.field_70161_v;
            ForgeEntity.setPosition(entity, vec);
        }
    }

    public void setAllPositions(ForgeVec3d vec) {
        ForgeEntity.setAllPositions(this, vec);
    }

    public static void setAllRotations(Entity entity, Rotation rotation) {
        if (entity != null && rotation != null) {
            entity.field_70127_C = entity.field_70125_A = rotation.pitch;
            entity.field_70126_B = entity.field_70177_z = rotation.yaw;
        }
    }

    public void setAllRotations(Rotation rotation) {
        ForgeEntity.setAllRotations(this, rotation);
    }

    public static float getSize(Entity entity) {
        if (entity != null) {
            return entity.field_70130_N * entity.field_70131_O;
        }
        return 0.0f;
    }

    public static int getId(Entity entity) {
        return entity != null ? entity.func_145782_y() : -1;
    }

    public int getId() {
        return ForgeEntity.getId(this);
    }

    public float getSize() {
        return ForgeEntity.getSize(this);
    }

    public static float getWeight(Entity entity) {
        if (entity != null) {
            float passengersWeight = 0.0f;
            for (Entity passenger : entity.func_184188_bt()) {
                passengersWeight += ForgeEntity.getSize(passenger);
            }
            return ForgeEntity.getSize(entity) + passengersWeight + ForgeEntity.getSize(entity.func_184187_bx());
        }
        return 0.0f;
    }

    public float getWeight() {
        return ForgeEntity.getWeight(this);
    }

    public static void updateBB(Entity entity) {
        if (entity != null) {
            entity.func_174826_a(ForgeEntity.getBB(entity, ForgeEntity.getPosition(entity)));
        }
    }

    public static AxisAlignedBB getBB(Entity entity, ForgeVec3d position) {
        if (entity != null && position != null) {
            double widthHalf = (double)entity.field_70130_N / 2.0;
            return new AxisAlignedBB(position.x - widthHalf, position.y, position.z - widthHalf, position.x + widthHalf, position.y + (double)entity.field_70131_O, position.z + widthHalf);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static AxisAlignedBB getBB(Entity entity) {
        return ForgeEntity.getBB(entity, ForgeEntity.getPosition(entity));
    }

    public AxisAlignedBB getBB(ForgeVec3d position) {
        return ForgeEntity.getBB(this, position);
    }

    public AxisAlignedBB getBB() {
        return ForgeEntity.getBB(this, this.getPositionVec());
    }

    public void updateBB() {
        ForgeEntity.updateBB(this);
    }

    public static void stopMoving(Entity entity) {
        if (entity != null) {
            ForgeEntity.setMotion(entity, ForgeVec3d.getZero());
        }
    }

    public void stopMoving() {
        ForgeEntity.stopMoving(this);
    }

    public static boolean isServerSide(Entity entity) {
        if (entity != null) {
            return ForgeWorld.isServerSide(entity.field_70170_p);
        }
        return false;
    }

    public boolean isServerSide() {
        return ForgeEntity.isServerSide(this);
    }

    public static boolean isClientSide(Entity entity) {
        if (entity != null) {
            return ForgeWorld.isClientSide(entity.field_70170_p);
        }
        return false;
    }

    public boolean isClientSide() {
        return ForgeEntity.isClientSide(this);
    }

    public ArrayList<Entity> getEntitiesWithinAABB(AxisAlignedBB aaBB) {
        if (this.field_70170_p != null) {
            return new ArrayList<Entity>(this.field_70170_p.func_72839_b((Entity)this, aaBB));
        }
        return new ArrayList<Entity>();
    }

    public static void setBB(Entity entity, ForgeVec3d minPoint, ForgeVec3d maxPoint) {
        if (entity != null && minPoint != null && maxPoint != null) {
            entity.func_174826_a(new AxisAlignedBB(minPoint.x, minPoint.y, minPoint.z, maxPoint.x, maxPoint.y, maxPoint.z));
        }
    }

    public void setBB(ForgeVec3d minPoint, ForgeVec3d maxPoint) {
        ForgeEntity.setBB(this, minPoint, maxPoint);
    }

    public static boolean hasSwingingPlayerPassenger(Entity entity) {
        if (entity != null) {
            for (Entity passenger : entity.func_184188_bt()) {
                if (!(passenger instanceof EntityPlayer) || !((EntityPlayer)passenger).field_82175_bq) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSwingingPlayerPassenger() {
        return ForgeEntity.hasSwingingPlayerPassenger(this);
    }
}

