/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.materials;

import com.endertech.common.Args;
import com.endertech.common.CommonString;
import com.endertech.common.Names;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeRecipe;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.units.ForgeItem;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class CraftingRecipe
extends ForgeRecipe {
    public final boolean isShapeless;
    public final String pattern;
    public final UnitId outputId;
    public final int amount;
    public final ArrayList<UnitId> components;
    protected final ForgeConfig config;

    protected static CraftingRecipe Create(ForgeRecipe.Type type, ForgeConfig config, String pattern, String output, int amount, String ... components) {
        String category = Names.join(CraftingRecipe.class.getSimpleName(), type.name());
        return new CraftingRecipe(config, category, pattern, output, amount, components);
    }

    public static CraftingRecipe CreateMain(ForgeConfig config, String pattern, String output, int amount, String ... components) {
        return CraftingRecipe.Create(ForgeRecipe.Type.main, config, pattern, output, amount, components);
    }

    public static CraftingRecipe CreateReserve(ForgeConfig config, String pattern, String output, int amount, String ... components) {
        return CraftingRecipe.Create(ForgeRecipe.Type.reserve, config, pattern, output, amount, components);
    }

    public CraftingRecipe(String pattern, String output, int amount, String ... components) {
        this(null, null, pattern, output, amount, components);
    }

    public CraftingRecipe(ForgeConfig config, String category, String pattern, String output, int amount, String ... components) {
        this.config = config;
        this.pattern = ForgeConfig.getStr(config, category, "pattern", pattern, "Shaped recipe pattern in format <nnnn> or <nnnnnnnnn>.\nWhere 'n' - number of recipe component (from 1 to 9).\nZero value (0) is for empty slot.\nIf pattern is empty, then recipe will be treated as shapeless.");
        this.isShapeless = CommonString.isNullOrEmpty(pattern);
        output = ForgeConfig.getStr(config, category, "output", output, "Output unit id.\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too.\nIn addition you may use '*' char as meta value to specify all possible values.\nOr you may use just NAME in ore dictionary format (examples: oreGold, gemDiamond, blockGrass)");
        this.outputId = new UnitId(output);
        this.amount = ForgeConfig.getInt(config, category, "amount", amount, ForgeBounds.stackSize.INT, "Amount of output units.");
        String[] componentsArray = ForgeConfig.getStrArray(config, category, "components", components, "Recipe components list.\nComponents should be represented by its ids.\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too.\nIn addition you may use '*' char as meta value to specify all possible values.\nOr you may use just NAME in ore dictionary format (examples: oreGold, gemDiamond, blockGrass)");
        this.components = new ArrayList();
        if (componentsArray != null) {
            for (int i = 0; i < componentsArray.length; ++i) {
                this.components.add(new UnitId(componentsArray[i]));
            }
        }
    }

    public ItemStack getOutputStack() {
        return ForgeItem.getItemStack(this.outputId, this.amount);
    }

    public Object[] getParams() {
        ArrayList<Object> objList = new ArrayList<Object>();
        if (this.pattern != null && this.components != null) {
            int gridSize = (int)Math.sqrt(this.pattern.length());
            assert (gridSize * gridSize == this.pattern.length());
            for (int i = 0; i < gridSize; ++i) {
                int beginIndex = i * gridSize;
                int endIndex = beginIndex + gridSize;
                objList.add(this.pattern.substring(beginIndex, endIndex).replace("0", " "));
            }
        }
        if (this.components != null) {
            for (int i = 0; i < this.components.size(); ++i) {
                if (!this.isShapeless) {
                    objList.add(Character.valueOf(String.valueOf(i + 1).charAt(0)));
                }
                objList.add(ForgeItem.getItemStack(this.components.get(i), 1));
            }
        }
        return objList.toArray();
    }

    @Override
    public boolean isValid() {
        this.statusDescription = "";
        if (UnitId.isNullOrEmpty(this.outputId) || this.components == null || this.components.isEmpty()) {
            this.statusDescription = "NULL or EMPTY arguments";
            return false;
        }
        int LENGTH_SHORT = 4;
        int LENGHT_FULL = 9;
        if (this.pattern != null) {
            int length = this.pattern.length();
            if (length != 4 && length != 9) {
                this.statusDescription = String.format("pattern length is %d, but should be %d or %d", length, 4, 9);
                return false;
            }
            for (char ch : this.pattern.toCharArray()) {
                String s = String.valueOf(ch);
                int i = 0;
                try {
                    i = Integer.parseInt(s);
                }
                catch (Exception e) {
                    this.statusDescription = String.format("pattern has unacceptable char '%s'", s);
                    return false;
                }
                if (i == 0 || --i >= 0 && i < this.components.size()) continue;
                this.statusDescription = String.format("pattern '%d' value refers to not existing component", i);
                return false;
            }
        }
        for (UnitId id : this.components) {
            if (!UnitId.isNullOrEmpty(id)) continue;
            this.statusDescription = "component name is NULL or EMPTY";
            return false;
        }
        if (this.isShapeless) {
            ArrayList<UnitId> list = new ArrayList<UnitId>();
            Object object = this.components.iterator();
            while (object.hasNext()) {
                UnitId id = (UnitId)object.next();
                if (list.contains(id)) {
                    this.statusDescription = "DUPLICATE components";
                    return false;
                }
                list.add(id);
            }
        }
        return true;
    }

    public String toString() {
        return CraftingRecipe.class.getSimpleName() + Args.group(Args.get("status", CraftingRecipe.getStatus(this)), Args.get("pattern", this.pattern), Args.get("output", this.getOutputStack() != null ? this.getOutputStack() : this.outputId), Args.get("components", this.components));
    }

    @Override
    public boolean isReadyToRegister() {
        if (this.getOutputStack() == null) {
            return false;
        }
        for (UnitId id : this.components) {
            if (id != null && ForgeItem.getItemStack(id, 1) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public ForgeConfig getConfig() {
        return this.config;
    }
}

