/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.materials;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.regs.ForgeRegistrator;
import com.endertech.minecraft.forge.units.ForgeItem;
import net.minecraft.creativetab.CreativeTabs;

public class ForgeMaterial
extends ForgeItem {
    public final String name;
    public final float strength;
    public final float frequency;
    public final float stability;
    public final float magicability;
    public final ColorARGB color;

    public ForgeMaterial(String modId, String name, ForgeRegistrator registrator, UnitConfig config, float strength, float frequency, float stability, float magicability, ColorARGB color) {
        super(modId, name, registrator, CreativeTabs.field_78035_l, config);
        this.name = name;
        String category = this.id.unitName;
        this.strength = ForgeConfig.getFloat(config, category, "strength", strength, ForgeBounds.strength.FLOAT, "Defines how strong material is. Affects: physical resistance, durability, weapons & tools power etc.");
        this.frequency = ForgeConfig.getFloat(config, category, "frequency", frequency, ForgeBounds.frequency.FLOAT, "Defines how often this material appears in the world. Affects: loot and ore generation.");
        this.stability = ForgeConfig.getFloat(config, category, "stability", stability, ForgeBounds.stability.FLOAT, "Defines how stable material is. Affects: explosion or fire probability on hit.");
        this.magicability = ForgeConfig.getFloat(config, category, "magicability", magicability, ForgeBounds.magicability.FLOAT, "Defines how magical the material is. Affects: enchantability, magic resistance.");
        String hexARGB = ForgeConfig.getStr(config, category, "color", color != null ? color.getHexARGB() : ColorARGB.DEFAULT.getHexARGB(), "Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)");
        this.color = new ColorARGB(hexARGB);
    }

    @Override
    public String toString() {
        return ForgeMaterial.class.getSimpleName() + Args.group(Args.get("strength", Float.valueOf(this.strength)), Args.get("frequency", Float.valueOf(this.frequency)), Args.get("stability", Float.valueOf(this.stability)), Args.get("magicability", Float.valueOf(this.magicability))) + Args.extend(super.toString());
    }
}

