/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.materials;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.materials.ForgeMaterial;

public class SmeltingData
implements IHaveConfig {
    protected final ForgeConfig config;
    public final int amount;
    public final float xp;

    public SmeltingData() {
        this(null, null, 1, 0.0f);
    }

    public SmeltingData(ForgeConfig config, String category, ForgeMaterial material) {
        this(config, category, material != null ? 1 : 0, material != null ? ForgeBounds.FloatApproxUp(material.strength, ForgeBounds.smeltingXP) : 0.0f);
    }

    public SmeltingData(ForgeConfig config, String category, int amount, float xp) {
        category = this.expandCategory(category);
        this.config = config;
        this.amount = ForgeConfig.getInt(config, category, "amount", amount, ForgeBounds.stackSize.INT, "How many items will be smelted from this ore");
        this.xp = ForgeConfig.getFloat(config, category, "xp", xp, ForgeBounds.experience.FLOAT, "How many experience will be gained from smelting");
    }

    public String toString() {
        return SmeltingData.class.getSimpleName() + Args.group(Args.get("amount", this.amount), Args.get("xp", Float.valueOf(this.xp)));
    }

    @Override
    public ForgeConfig getConfig() {
        return this.config;
    }
}

