/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.materials;

import com.endertech.common.Args;
import com.endertech.common.Names;
import com.endertech.minecraft.forge.ForgeRecipe;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.materials.ISmeltable;
import com.endertech.minecraft.forge.materials.SmeltingData;
import com.endertech.minecraft.forge.units.ForgeItem;
import com.endertech.minecraft.forge.units.UnitId;
import net.minecraft.item.ItemStack;

public class SmeltingRecipe
extends ForgeRecipe
implements ISmeltable {
    public final UnitId inputId;
    public final UnitId outputId;
    public final SmeltingData smeltingData;
    protected final ForgeConfig config;

    protected static SmeltingRecipe Create(ForgeRecipe.Type type, ForgeConfig config, String input, String output, int amount, float xp) {
        String category = Names.join(SmeltingRecipe.class.getSimpleName(), type.name());
        return new SmeltingRecipe(config, category, input, output, amount, xp);
    }

    public static SmeltingRecipe CreateMain(ForgeConfig config, String input, String output, int amount, float xp) {
        return SmeltingRecipe.Create(ForgeRecipe.Type.main, config, input, output, amount, xp);
    }

    public static SmeltingRecipe CreateReserve(ForgeConfig config, String input, String output, int amount, float xp) {
        return SmeltingRecipe.Create(ForgeRecipe.Type.reserve, config, input, output, amount, xp);
    }

    public SmeltingRecipe(ForgeConfig config, String category, String input, String output, int amount, float xp) {
        this.config = config;
        input = ForgeConfig.getStr(config, category, "inputId", input, "Input unit id.\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too.\nIn addition you may use '*' char as meta value to specify all possible values.\nOr you may use just NAME in ore dictionary format (examples: oreGold, gemDiamond, blockGrass)");
        this.inputId = new UnitId(input);
        output = ForgeConfig.getStr(config, category, "outputId", output, "Output unit id.\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too.\nIn addition you may use '*' char as meta value to specify all possible values.\nOr you may use just NAME in ore dictionary format (examples: oreGold, gemDiamond, blockGrass)");
        this.outputId = new UnitId(output);
        this.smeltingData = new SmeltingData(config, category, amount, xp);
    }

    public SmeltingRecipe(String inputName, String outputName, int amount, float xp) {
        this(null, null, inputName, outputName, amount, xp);
    }

    @Override
    public boolean isValid() {
        if (UnitId.isNullOrEmpty(this.inputId) || UnitId.isNullOrEmpty(this.outputId)) {
            this.statusDescription = "NULL or EMPTY arguments";
            return false;
        }
        if (this.getSmeltingData().amount <= 0) {
            this.statusDescription = "Wrong amount";
            return false;
        }
        return true;
    }

    public ItemStack getInputStack() {
        return ForgeItem.getItemStack(this.inputId, 1);
    }

    public ItemStack getOutputStack() {
        return ForgeItem.getItemStack(this.outputId, this.getSmeltingData().amount);
    }

    @Override
    public SmeltingData getSmeltingData() {
        return this.smeltingData;
    }

    public String toString() {
        return SmeltingRecipe.class.getSimpleName() + Args.group(Args.get("status", SmeltingRecipe.getStatus(this)), Args.get("input", this.getInputStack() != null ? this.getInputStack() : this.inputId), Args.get("output", this.getOutputStack() != null ? this.getOutputStack() : this.outputId), Args.get("smeltingData", this.getSmeltingData()));
    }

    @Override
    public boolean isReadyToRegister() {
        return ForgeItem.getItemStack(this.inputId, 1) != null && ForgeItem.getItemStack(this.outputId, 1) != null;
    }

    @Override
    public ForgeConfig getConfig() {
        return this.config;
    }
}

