/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.math;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.entities.Rotation;
import com.endertech.minecraft.forge.math.ForgeMath;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class ForgeVec3d {
    public final double x;
    public final double y;
    public final double z;

    public ForgeVec3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public ForgeVec3d(Vec3d vec3) {
        this(vec3 != null ? vec3.field_72450_a : 0.0, vec3 != null ? vec3.field_72448_b : 0.0, vec3 != null ? vec3.field_72449_c : 0.0);
    }

    public ForgeVec3d(BlockPos pos) {
        this(pos != null ? (double)pos.func_177958_n() : 0.0, pos != null ? (double)pos.func_177956_o() : 0.0, pos != null ? (double)pos.func_177952_p() : 0.0);
    }

    public static ForgeVec3d getZero() {
        return new ForgeVec3d(0.0, 0.0, 0.0);
    }

    public static ForgeVec3d getDifference(ForgeVec3d vecA, ForgeVec3d vecB) {
        if (vecA == null) {
            vecA = ForgeVec3d.getZero();
        }
        if (vecB == null) {
            vecB = ForgeVec3d.getZero();
        }
        return new ForgeVec3d(vecA.x - vecB.x, vecA.y - vecB.y, vecA.z - vecB.z);
    }

    public static ForgeVec3d getMult(ForgeVec3d vecA, ForgeVec3d vecB) {
        if (vecA != null && vecB != null) {
            return new ForgeVec3d(vecA.y * vecB.z - vecA.z * vecB.y, vecA.z * vecB.x - vecA.x * vecB.z, vecA.x * vecB.y - vecA.y * vecB.x);
        }
        return ForgeVec3d.getZero();
    }

    public static ForgeVec3d getNormalized(ForgeVec3d vec) {
        double length = ForgeVec3d.getLength(vec);
        if (length >= 1.0E-4) {
            return new ForgeVec3d(vec.x / length, vec.y / length, vec.z / length);
        }
        return ForgeVec3d.getZero();
    }

    public static ForgeVec3d getSum(ForgeVec3d vecA, ForgeVec3d vecB) {
        if (vecA == null) {
            vecA = ForgeVec3d.getZero();
        }
        if (vecB == null) {
            vecB = ForgeVec3d.getZero();
        }
        return new ForgeVec3d(vecA.x + vecB.x, vecA.y + vecB.y, vecA.z + vecB.z);
    }

    public static double getScalarMult(ForgeVec3d vecA, ForgeVec3d vecB) {
        if (vecA != null && vecB != null) {
            return vecA.x * vecB.x + vecA.y * vecB.y + vecA.z * vecB.z;
        }
        return 0.0;
    }

    public static double getAngle(ForgeVec3d vecA, ForgeVec3d vecB) {
        return CommonMath.getDegrees(Math.acos(ForgeVec3d.getScalarMult(vecA, vecB)));
    }

    public static ForgeVec3d getApprox(float factor, ForgeVec3d vecA, ForgeVec3d vecB) {
        if (vecA == null) {
            vecA = ForgeVec3d.getZero();
        }
        if (vecB == null) {
            vecB = ForgeVec3d.getZero();
        }
        float x = CommonMath.getApproxUp(factor, new FloatBounds((float)vecA.x, (float)vecB.x));
        float y = CommonMath.getApproxUp(factor, new FloatBounds((float)vecA.y, (float)vecB.y));
        float z = CommonMath.getApproxUp(factor, new FloatBounds((float)vecA.z, (float)vecB.z));
        return new ForgeVec3d(x, y, z);
    }

    public ForgeVec3d approximate(float factor, ForgeVec3d vec) {
        return ForgeVec3d.getApprox(factor, this, vec);
    }

    public static double getLength(ForgeVec3d vec) {
        if (vec != null) {
            return Math.sqrt(vec.x * vec.x + vec.y * vec.y + vec.z * vec.z);
        }
        return 0.0;
    }

    public double getLength() {
        return ForgeVec3d.getLength(this);
    }

    public static ForgeVec3d setLength(ForgeVec3d vec, double length) {
        if (vec != null && vec.notZero()) {
            double factor = length / vec.getLength();
            return vec.scale(factor);
        }
        return ForgeVec3d.getZero();
    }

    public ForgeVec3d resize(double length) {
        return ForgeVec3d.setLength(this, length);
    }

    public ForgeVec3d truncate(double length) {
        if (this.getLength() > length) {
            return ForgeVec3d.setLength(this, length);
        }
        return this;
    }

    public ForgeVec3d expand(double length) {
        if (this.getLength() < length) {
            return ForgeVec3d.setLength(this, length);
        }
        return this;
    }

    public boolean isZero() {
        return !this.notZero();
    }

    public boolean notZero() {
        return CommonMath.notZero(this.x) || CommonMath.notZero(this.y) || CommonMath.notZero(this.z);
    }

    public ForgeVec3d add(ForgeVec3d vec) {
        return ForgeVec3d.getSum(this, vec);
    }

    public ForgeVec3d add(double scalar) {
        return new ForgeVec3d(this.x + scalar, this.y + scalar, this.z + scalar);
    }

    public ForgeVec3d subtract(ForgeVec3d vec) {
        return ForgeVec3d.getDifference(this, vec);
    }

    public ForgeVec3d subtract(double scalar) {
        return new ForgeVec3d(this.x - scalar, this.y - scalar, this.z - scalar);
    }

    public ForgeVec3d move(double dx, double dy, double dz) {
        return new ForgeVec3d(this.x + dx, this.y + dy, this.z + dz);
    }

    public static ForgeVec3d getScaled(ForgeVec3d vec, double scale) {
        return vec != null ? new ForgeVec3d(vec.x * scale, vec.y * scale, vec.z * scale) : ForgeVec3d.getZero();
    }

    public ForgeVec3d scale(double scale) {
        return ForgeVec3d.getScaled(this, scale);
    }

    public static ForgeVec3d getInverted(ForgeVec3d vec) {
        return vec != null ? new ForgeVec3d(-vec.x, -vec.y, -vec.z) : ForgeVec3d.getZero();
    }

    public ForgeVec3d invert() {
        return ForgeVec3d.getInverted(this);
    }

    public static ForgeVec3d getDivided(ForgeVec3d vec, double divider) {
        return vec != null && CommonMath.notZero(divider) ? new ForgeVec3d(vec.x / divider, vec.y / divider, vec.z / divider) : ForgeVec3d.getZero();
    }

    public ForgeVec3d divide(double divider) {
        return ForgeVec3d.getDivided(this, divider);
    }

    public static double getDistance(ForgeVec3d vecA, ForgeVec3d vecB) {
        return ForgeVec3d.getDifference(vecA, vecB).getLength();
    }

    public double getDistance(ForgeVec3d vec) {
        return ForgeVec3d.getDistance(this, vec);
    }

    public float getPitch() {
        double length = Math.sqrt(this.x * this.x + this.z * this.z);
        return ForgeMath.arcTan(this.y, length);
    }

    public float getYaw() {
        return ForgeMath.arcTan(this.x, this.z);
    }

    public static Rotation getRotation(ForgeVec3d vec) {
        if (vec != null) {
            return new Rotation(vec.getPitch(), vec.getYaw());
        }
        return Rotation.getZero();
    }

    public static Rotation getRotationWrapped(ForgeVec3d vec) {
        if (vec != null) {
            float pitch = MathHelper.func_76142_g((float)vec.getPitch());
            float yaw = MathHelper.func_76142_g((float)vec.getYaw());
            return new Rotation(pitch, yaw);
        }
        return Rotation.getZero();
    }

    public Rotation getRotation() {
        return ForgeVec3d.getRotation(this);
    }

    public Rotation getRotationWrapped() {
        return ForgeVec3d.getRotationWrapped(this);
    }

    public static ForgeVec3d getMaxOfAll(ForgeVec3d vecA, ForgeVec3d vecB) {
        if (vecA == null) {
            vecA = ForgeVec3d.getZero();
        }
        if (vecB == null) {
            vecB = ForgeVec3d.getZero();
        }
        return new ForgeVec3d(Math.max(vecA.x, vecB.x), Math.max(vecA.y, vecB.y), Math.max(vecA.z, vecB.z));
    }

    public static ForgeVec3d getMinOfAllByAbs(ForgeVec3d vecA, ForgeVec3d vecB) {
        if (vecA == null) {
            vecA = ForgeVec3d.getZero();
        }
        if (vecB == null) {
            vecB = ForgeVec3d.getZero();
        }
        return new ForgeVec3d(CommonMath.getMinByAbs(vecA.x, vecB.x), CommonMath.getMinByAbs(vecA.y, vecB.y), CommonMath.getMinByAbs(vecA.z, vecB.z));
    }

    public static ForgeVec3d getRotatedAroundX(ForgeVec3d vec, float degrees) {
        if (vec != null) {
            float cosA = ForgeMath.cos(degrees);
            float sinA = ForgeMath.sin(degrees);
            return new ForgeVec3d(vec.x, vec.y * (double)cosA + vec.z * (double)sinA, vec.z * (double)cosA - vec.y * (double)sinA);
        }
        return ForgeVec3d.getZero();
    }

    public ForgeVec3d rotateAroundX(float degrees) {
        return ForgeVec3d.getRotatedAroundX(this, degrees);
    }

    public static ForgeVec3d getRotatedAroundY(ForgeVec3d vec, float degrees) {
        if (vec != null) {
            float cosA = ForgeMath.cos(degrees);
            float sinA = ForgeMath.sin(degrees);
            return new ForgeVec3d(vec.x * (double)cosA + vec.z * (double)sinA, vec.y, vec.z * (double)cosA - vec.x * (double)sinA);
        }
        return ForgeVec3d.getZero();
    }

    public ForgeVec3d rotateAroundY(float degrees) {
        return ForgeVec3d.getRotatedAroundY(this, degrees);
    }

    public static ForgeVec3d getRotatedAroundZ(ForgeVec3d vec, float degrees) {
        if (vec != null) {
            float cosA = ForgeMath.cos(degrees);
            float sinA = ForgeMath.sin(degrees);
            return new ForgeVec3d(vec.x * (double)cosA + vec.y * (double)sinA, vec.y * (double)cosA - vec.x * (double)sinA, vec.z);
        }
        return ForgeVec3d.getZero();
    }

    public ForgeVec3d rotateAroundZ(float degrees) {
        return ForgeVec3d.getRotatedAroundZ(this, degrees);
    }

    public ForgeVec3d mult(ForgeVec3d vec) {
        return ForgeVec3d.getMult(this, vec);
    }

    public ForgeVec3d normalize() {
        return ForgeVec3d.getNormalized(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ForgeVec3d) {
            ForgeVec3d vec = (ForgeVec3d)obj;
            return vec.x == this.x && vec.y == this.y && vec.z == this.z;
        }
        return super.equals(obj);
    }

    public boolean notEqual(ForgeVec3d vec) {
        return !this.equals(vec);
    }

    public Vec3d toVec3() {
        return new Vec3d(this.x, this.y, this.z);
    }

    public String toString() {
        return "Vec3d (x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }
}

