/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.messages;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.ForgeVec3d;
import com.endertech.minecraft.forge.messages.IForgeMsgHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MotionMsg
implements IMessage {
    int id = -1;
    Type type = Type.add;
    ForgeVec3d motion = ForgeVec3d.getZero();

    public MotionMsg() {
    }

    public static MotionMsg setMotion(Entity entity, ForgeVec3d motion) {
        return new MotionMsg(entity, Type.set, motion);
    }

    public static MotionMsg addMotion(Entity entity, ForgeVec3d motion) {
        return new MotionMsg(entity, Type.add, motion);
    }

    public MotionMsg(Entity entity, Type type, ForgeVec3d motion) {
        if (entity != null) {
            this.id = ForgeEntity.getId(entity);
        }
        if (type != null) {
            this.type = type;
        }
        if (motion != null) {
            this.motion = motion;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.type = Type.values()[buf.readInt()];
        this.motion = new ForgeVec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.type.ordinal());
        buf.writeDouble(this.motion.x);
        buf.writeDouble(this.motion.y);
        buf.writeDouble(this.motion.z);
    }

    public static enum Type {
        add,
        set;

    }

    public static class Handler
    implements IForgeMsgHandler<MotionMsg> {
        public IMessage onMessage(MotionMsg message, MessageContext ctx) {
            Entity entity;
            if (message != null && message.type != null && (entity = this.findEntity(ctx, message.id)) != null) {
                switch (message.type) {
                    case add: {
                        ForgeEntity.addMotion(entity, message.motion);
                        break;
                    }
                    case set: {
                        ForgeEntity.setMotion(entity, message.motion);
                        break;
                    }
                }
            }
            return null;
        }
    }
}

