/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.messages;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.messages.IForgeMsgHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class UpdateBlockMsg
implements IMessage {
    public BlockPos pos = BlockPos.field_177992_a;

    public UpdateBlockMsg() {
    }

    public UpdateBlockMsg(BlockPos pos) {
        if (pos != null) {
            this.pos = pos;
        }
    }

    public UpdateBlockMsg(int x, int y, int z) {
        this(new BlockPos(x, y, z));
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        if (this.pos != null) {
            buf.writeInt(this.pos.func_177958_n());
            buf.writeInt(this.pos.func_177956_o());
            buf.writeInt(this.pos.func_177952_p());
        }
    }

    public static class ClientHandler
    implements IForgeMsgHandler<UpdateBlockMsg> {
        public IMessage onMessage(UpdateBlockMsg message, MessageContext ctx) {
            Block block;
            IBlockState blockState;
            World world;
            if (message != null && message.pos != null && ctx != null && (world = this.getWorld(ctx)) != null && (blockState = world.func_180495_p(message.pos)) != null && (block = blockState.func_177230_c()) != null && block != Blocks.field_150350_a) {
                block.func_180650_b(world, message.pos, blockState, CommonMath.random);
            }
            return null;
        }
    }
}

