/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.messages;

import com.endertech.minecraft.forge.messages.IForgeMsgHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class UsingItemMsg
implements IMessage {
    public Type type = Type.start;

    public UsingItemMsg() {
    }

    public UsingItemMsg(Type type) {
        if (type != null) {
            this.type = type;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.type = Type.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
    }

    public static class ServerHandler
    implements IForgeMsgHandler<UsingItemMsg> {
        public IMessage onMessage(UsingItemMsg message, MessageContext ctx) {
            if (message != null && message.type != null && ctx != null) {
                World world = this.getWorld(ctx);
                EntityPlayer player = this.getPlayer(ctx);
                ItemStack stack = player.field_71071_by.func_70448_g();
                if (stack != null && stack.func_77973_b() != null) {
                    switch (message.type) {
                        case start: {
                            stack.func_77973_b().func_77659_a(stack, world, player, EnumHand.MAIN_HAND);
                            break;
                        }
                        case end: {
                            stack.func_77973_b().func_77615_a(stack, world, (EntityLivingBase)player, Integer.MAX_VALUE);
                            break;
                        }
                    }
                }
            }
            return null;
        }
    }

    public static enum Type {
        start,
        end;

    }
}

