/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.ores;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.Dimensions;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.materials.ForgeMaterial;
import net.minecraft.block.Block;

public class GenerationData {
    public final int minY;
    public final int maxY;
    public final int blocksInVein;
    public final int veinsInChunk;
    public final float dispersion;
    public final int dimensionId;
    public final int targetBlockId;

    public GenerationData(UnitConfig config, String category, ForgeMaterial material) {
        this(config, category, ForgeBounds.oreY.INT.min, ForgeBounds.IntApproxUp(material.frequency, ForgeBounds.oreY), ForgeBounds.IntApproxUp(material.frequency, ForgeBounds.oreBlocksInVein), ForgeBounds.IntApproxUp(material.frequency, ForgeBounds.oreVeinsInChunk), ForgeBounds.FloatApproxUp(0.5f, ForgeBounds.dispersion));
    }

    public GenerationData(UnitConfig config, String category, int minY, int maxY, int blocksInVein, int veinsInChunk, float dispersion) {
        this.minY = UnitConfig.getInt(config, category, "minY", minY, ForgeBounds.height.INT, "Minimal height which ore will be generated at.");
        this.maxY = UnitConfig.getInt(config, category, "maxY", maxY, ForgeBounds.height.INT, "Maximal height which ore will be generated at.");
        this.blocksInVein = UnitConfig.getInt(config, category, "blocksInVein", blocksInVein, ForgeBounds.oreBlocksInVein.INT, "Number of ore blocks in one vein");
        this.veinsInChunk = UnitConfig.getInt(config, category, "veinsInChunk", veinsInChunk, ForgeBounds.oreVeinsInChunk.INT, "Number of ore veins in one chunk");
        this.dispersion = UnitConfig.getFloat(config, category, "dispersion", dispersion, ForgeBounds.dispersion.FLOAT, "Amount dispersion where 1 means 100%");
        this.dimensionId = UnitConfig.getInt(config, category, "dimensionId", Dimensions.overworld.ID, ForgeBounds.dimensionId.INT, "Dimension which the ore will be generated at.");
        this.targetBlockId = UnitConfig.getInt(config, category, "targetBlockId", Block.func_149682_b((Block)Dimensions.overworld.targetBlock), ForgeBounds.blockId.INT, "Id of a block which should be replaced by the generated ore.");
    }

    protected int getDispersed(int value) {
        float disp = Math.max(1.0f, (float)value * this.dispersion) * CommonMath.random.nextFloat();
        if (CommonMath.random.nextBoolean()) {
            disp = -disp;
        }
        return value + CommonMath.getRounded(disp);
    }

    public int getY() {
        return CommonMath.getRandom(this.minY, this.maxY);
    }

    public int getBlocksInVein() {
        return CommonMath.getInRange(this.getDispersed(this.blocksInVein), ForgeBounds.oreBlocksInVein.INT);
    }

    public int getVeinsInChunk() {
        return CommonMath.getInRange(this.getDispersed(this.veinsInChunk), ForgeBounds.oreVeinsInChunk.INT);
    }

    public String toString() {
        return GenerationData.class.getSimpleName() + Args.group(Args.get("minY", this.minY), Args.get("maxY", this.maxY), Args.get("blocksInVein", this.blocksInVein), Args.get("veinsInChunk", this.veinsInChunk), Args.get("dispersion", Float.valueOf(this.dispersion)), Args.get("dimensionId", this.dimensionId), Args.get("targetBlockId", this.targetBlockId));
    }
}

