/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.regs;

import com.endertech.common.Console;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.ForgeRendering;
import com.endertech.minecraft.forge.materials.CraftingRecipe;
import com.endertech.minecraft.forge.materials.SmeltingRecipe;
import com.endertech.minecraft.forge.units.ForgeBlock;
import com.endertech.minecraft.forge.units.ForgeItem;
import com.endertech.minecraft.forge.units.IForgeUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ForgeRegistrator {
    public static final String FORMAT_REGISTERED = "registered: %s";
    public static final String FORMAT_REMAINS_UNREGISTERED = "remains UNREGISTERED: %s";
    public static final String FORMAT_SKIPPED = "SKIPPED: %s";
    public final SimpleNetworkWrapper networkChannel;
    protected int discriminator = 0;
    protected ArrayList<IForgeUnit> unregisteredUnits = new ArrayList();
    protected ArrayList<IForgeUnit> registeredUnits = new ArrayList();
    protected HashMap<CraftingRecipe, CraftingRecipe> craftings = new HashMap();
    protected ArrayList<SmeltingRecipe> smeltings = new ArrayList();

    public ForgeRegistrator(String modId) {
        this.networkChannel = NetworkRegistry.INSTANCE.newSimpleChannel(modId);
    }

    public static void addUnit(ForgeRegistrator registrator, IForgeUnit unit) {
        if (registrator != null) {
            registrator.unregisteredUnits.add(unit);
        }
    }

    public static void addBlockCrafting(ForgeRegistrator registrator, String itemId, String blockId) {
        CraftingRecipe recipe = new CraftingRecipe("111111111", blockId, 1, itemId);
        ForgeRegistrator.addCrafting(registrator, recipe);
        recipe = new CraftingRecipe(null, itemId, 9, blockId);
        ForgeRegistrator.addCrafting(registrator, recipe);
    }

    public static void addBlockCrafting(ForgeRegistrator registrator, IForgeUnit item, IForgeUnit block) {
        ForgeRegistrator.addBlockCrafting(registrator, item.getId().toString(), block.getId().toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void registerUnits() {
        String format = "registered: %s as %s";
        Iterator<IForgeUnit> iterator = this.unregisteredUnits.iterator();
        while (true) {
            block11: {
                IForgeUnit unit;
                block9: {
                    block10: {
                        if (!iterator.hasNext()) {
                            return;
                        }
                        unit = iterator.next();
                        if (unit == null) break block9;
                        if (!unit.isReadyToRegister()) break block10;
                        if (unit.isEnabled()) {
                            ResourceLocation location = unit.getId().toResLoc();
                            if (unit instanceof ForgeBlock) {
                                ForgeBlock block = (ForgeBlock)unit;
                                GameRegistry.register((IForgeRegistryEntry)block, (ResourceLocation)location);
                                GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)block).setRegistryName(location));
                                OreDictionary.registerOre((String)block.getId().unitName, (Block)block);
                                Console.msg("registered: %s as %s", block.getId(), block.toString());
                            } else if (unit instanceof ForgeItem) {
                                ForgeItem item = (ForgeItem)unit;
                                GameRegistry.register((IForgeRegistryEntry)item, (ResourceLocation)location);
                                OreDictionary.registerOre((String)item.getId().unitName, (Item)item);
                                Console.msg("registered: %s as %s", item.getId(), item.toString());
                            } else {
                                Console.msgError("FAILED to register: '%s' is neither block nor item!", unit.getId());
                            }
                            if (unit.isRegistered()) {
                                this.registeredUnits.add(unit);
                            }
                            break block11;
                        } else {
                            Console.msg(FORMAT_SKIPPED, unit);
                        }
                        break block11;
                    }
                    Console.msg(FORMAT_SKIPPED, unit);
                    continue;
                }
                Console.msgError(FORMAT_SKIPPED, IForgeUnit.getStatus(unit));
            }
            iterator.remove();
        }
    }

    public static void addCrafting(ForgeRegistrator registrator, CraftingRecipe recipe) {
        ForgeRegistrator.addCrafting(registrator, recipe, null);
    }

    public static void addCrafting(ForgeRegistrator registrator, CraftingRecipe main, CraftingRecipe reserve) {
        if (registrator != null && main != null) {
            registrator.craftings.put(main, reserve);
        }
    }

    public static void addSmelting(ForgeRegistrator registrator, SmeltingRecipe recipe) {
        if (registrator != null) {
            registrator.smeltings.add(recipe);
        }
    }

    protected void processInits(Side side) {
        Iterator<IForgeUnit> iterator = this.registeredUnits.iterator();
        while (iterator.hasNext()) {
            IForgeUnit unit = iterator.next();
            if (unit != null) {
                if (unit.isRegistered()) {
                    unit.onInit();
                    if (side == Side.CLIENT) {
                        unit.onInitClient();
                    }
                } else {
                    Console.msgError("Attempt to init NOT REGISTERED unit: " + unit);
                }
            }
            iterator.remove();
        }
    }

    public void onPreInit(FMLPreInitializationEvent event) {
        this.registerUnits();
    }

    public void onInit(FMLInitializationEvent event) {
        this.registerUnits();
        this.registerRecipes(false);
        this.processInits(event.getSide());
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        this.registerUnits();
        this.registerRecipes(false);
        this.registerRecipes(true);
        this.processInits(event.getSide());
        for (IForgeUnit iForgeUnit : this.unregisteredUnits) {
            Console.msg(FORMAT_REMAINS_UNREGISTERED, iForgeUnit);
        }
        for (CraftingRecipe craftingRecipe : this.craftings.keySet()) {
            Console.msg(FORMAT_REMAINS_UNREGISTERED, craftingRecipe);
        }
        for (SmeltingRecipe smeltingRecipe : this.smeltings) {
            Console.msg(FORMAT_REMAINS_UNREGISTERED, smeltingRecipe);
        }
        this.unregisteredUnits.clear();
        this.registeredUnits.clear();
        this.craftings.clear();
        this.smeltings.clear();
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<? extends IMessageHandler<REQ, REPLY>> messageHandler, Class<REQ> requestMessageType, Side side) {
        this.networkChannel.registerMessage(messageHandler, requestMessageType, this.discriminator++, side);
    }

    protected void registerRecipes(boolean useReserve) {
        this.registerCraftings(useReserve);
        this.registerSmeltings();
    }

    protected void registerCraftings(boolean useReserve) {
        Iterator<CraftingRecipe> iterator;
        Iterator<CraftingRecipe> iterator2 = iterator = useReserve ? this.craftings.values().iterator() : this.craftings.keySet().iterator();
        while (iterator.hasNext()) {
            CraftingRecipe recipe = iterator.next();
            if (recipe != null && recipe.isValid()) {
                if (recipe.isReadyToRegister()) {
                    if (recipe.isShapeless) {
                        GameRegistry.addShapelessRecipe((ItemStack)recipe.getOutputStack(), (Object[])recipe.getParams());
                    } else {
                        GameRegistry.addShapedRecipe((ItemStack)recipe.getOutputStack(), (Object[])recipe.getParams());
                    }
                    iterator.remove();
                    continue;
                }
            } else {
                iterator.remove();
            }
            Console.msg(FORMAT_SKIPPED, recipe);
        }
    }

    protected void registerSmeltings() {
        Iterator<SmeltingRecipe> iterator = this.smeltings.iterator();
        while (iterator.hasNext()) {
            SmeltingRecipe recipe = iterator.next();
            if (recipe != null && recipe.isValid()) {
                if (recipe.isReadyToRegister()) {
                    GameRegistry.addSmelting((ItemStack)recipe.getInputStack(), (ItemStack)recipe.getOutputStack(), (float)recipe.getSmeltingData().xp);
                    Console.msg(FORMAT_REGISTERED, recipe);
                    iterator.remove();
                    continue;
                }
            } else {
                iterator.remove();
            }
            Console.msg(FORMAT_SKIPPED, SmeltingRecipe.getStatus(recipe), recipe);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModel(ForgeItem item) {
        if (item != null) {
            this.registerItemModel((Item)item, item.getId().meta, item.getId().toModelResLoc_Inventory());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModel(Item item, int meta, ModelResourceLocation model) {
        if (item != null && model != null) {
            ForgeRendering.getMesher().func_178086_a(item, meta, model);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModel(Item item, ItemMeshDefinition definition, ResourceLocation ... locations) {
        if (item != null && definition != null && locations != null) {
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])locations);
            ForgeRendering.getMesher().func_178080_a(item, definition);
        }
    }

    public <T extends Entity> void registerEntity(ForgeMod mod, Class<T> entityClass, int trackingRange, int updateFrequency, boolean sendVelocity) {
        EntityRegistry.registerModEntity(entityClass, (String)entityClass.getSimpleName(), (int)this.discriminator++, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendVelocity);
    }
}

