/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.common.Args;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.regs.ForgeRegistrator;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.UnitEnabled;
import com.endertech.minecraft.forge.units.UnitId;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ForgeBlock
extends Block
implements IForgeUnit {
    public static final int BLOCKS_IN_CHUNK = 16;
    public final UnitEnabled enabled;
    protected final ForgeConfig config;
    protected final UnitId id;
    protected final ForgeRegistrator registrator;

    public ForgeBlock(String modId, String name, Material material, ForgeRegistrator registrator, CreativeTabs tab, UnitConfig config) {
        super(material);
        String blockName;
        String category = blockName = this.getOreDictionaryName(name);
        this.config = config;
        this.enabled = new UnitEnabled(config, category, true);
        this.id = new UnitId(modId, blockName);
        this.registrator = registrator;
        this.func_149663_c(blockName);
        this.func_149647_a(tab);
        ForgeRegistrator.addUnit(registrator, this);
    }

    public ForgeBlock(String modId, String name, Material material, float hardness, float resistance, ForgeRegistrator registrator, CreativeTabs tab, UnitConfig config) {
        this(modId, name, material, registrator, tab, config);
        this.setHardness(hardness);
        this.setResistance(resistance);
    }

    @Nullable
    public static Block findBlock(UnitId blockId) {
        return Block.func_149684_b((String)blockId.toString_NoMeta());
    }

    @Nonnull
    public static UnitId findBlockId(Block block) {
        ResourceLocation location = (ResourceLocation)field_149771_c.func_177774_c((Object)block);
        return new UnitId(location.toString());
    }

    public static Block getBlock(UnitId blockId, Block defaultBlock) {
        Block block = ForgeBlock.findBlock(blockId);
        return block != null ? block : defaultBlock;
    }

    public static Block getBlock(World world, BlockPos pos) {
        if (world != null && pos != null) {
            return world.func_180495_p(pos).func_177230_c();
        }
        return Blocks.field_150350_a;
    }

    public static Block getBlock(int id) {
        return Block.func_149729_e((int)id);
    }

    public float getHardness() {
        return this.field_149782_v;
    }

    public float getResistance() {
        return this.field_149781_w;
    }

    public ForgeBlock setResistance(float resistance) {
        this.field_149781_w = resistance;
        return this;
    }

    public ForgeBlock setLightValue(int value) {
        this.field_149784_t = value;
        return this;
    }

    public ForgeBlock setHardness(float hardness) {
        this.field_149782_v = hardness;
        return this;
    }

    public String toString() {
        return ForgeBlock.class.getSimpleName() + Args.group(Args.get("status", IForgeUnit.getStatus(this)), Args.get("unitName", this.id.unitName), Args.get("enabled", this.isEnabled()), Args.get("hardness", Float.valueOf(this.getHardness())), Args.get("resistance", Float.valueOf(this.getResistance())), Args.get("harvestLevel", this.getHarvestLevel(this.func_176223_P())));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.value;
    }

    @Override
    public boolean isRegistered() {
        return Block.func_149682_b((Block)this) != -1;
    }

    @Override
    public void onInit() {
        String category = this.id.unitName;
        float hardness = UnitConfig.getFloat(this.config, category, "hardness", this.getHardness(), new FloatBounds(-1.0f, Float.MAX_VALUE), "Defines how many hits it takes to break the block.\n -1 makes the block indestructible.");
        float resistance = UnitConfig.getFloat(this.config, category, "resistance", this.getResistance(), new FloatBounds(0.0f, Float.MAX_VALUE), "Defines the block resistance to explosions.");
        this.setHardness(hardness);
        this.setResistance(resistance);
        if (this.config != null) {
            this.config.save();
        }
    }

    @Override
    public boolean isReadyToRegister() {
        return true;
    }

    @Override
    public UnitId getId() {
        return this.id;
    }

    @Override
    public ForgeConfig getConfig() {
        return this.config;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onInitClient() {
        this.getRegistrator().registerItemModel(Item.func_150898_a((Block)this), this.id.meta, this.id.toModelResLoc_Inventory());
    }

    @Override
    public ForgeRegistrator getRegistrator() {
        return this.registrator;
    }
}

