/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.common.Console;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.regs.ForgeRegistrator;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.UnitEnabled;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ForgeItem
extends Item
implements IForgeUnit {
    public final UnitEnabled enabled;
    protected final ForgeConfig config;
    protected final UnitId id;
    protected final ForgeRegistrator registrator;

    @Nullable
    public static ItemStack getItemStack(UnitId unitId, int amount, boolean searchInOreDictToo) {
        if (unitId != null) {
            Item item = ForgeItem.findItem(unitId);
            if (item != null) {
                return new ItemStack(item, amount, unitId.meta);
            }
            if (searchInOreDictToo) {
                return ForgeItem.getItemStackFromOreDict(unitId.unitName, amount);
            }
        }
        return null;
    }

    @Nullable
    public static ItemStack getItemStack(UnitId unitId, int amount) {
        return ForgeItem.getItemStack(unitId, amount, true);
    }

    @Nullable
    public static ItemStack getItemStackOrNull(IForgeUnit unit, int amount) {
        String CANT_CREATE_STACK = "Can't create stack: ";
        if (unit != null) {
            if (unit.isRegistered()) {
                if (unit instanceof Block) {
                    return new ItemStack((Block)unit, amount);
                }
                if (unit instanceof Item) {
                    return new ItemStack((Item)unit, amount);
                }
                Console.msgError("Can't create stack: specified unit is neither block nor item!");
            } else {
                Console.msgError("Can't create stack: unit is not registered!");
            }
        } else {
            Console.msgError("Can't create stack: unit is NULL!");
        }
        return null;
    }

    @Nullable
    public static ItemStack getItemStackFromOreDict(String oreDictName, int amount) {
        List list;
        if (oreDictName != null && (list = OreDictionary.getOres((String)oreDictName, (boolean)false)) != null && !list.isEmpty()) {
            ItemStack stack = (ItemStack)list.get(0);
            if (stack != null) {
                stack.field_77994_a = amount;
            }
            return stack;
        }
        return null;
    }

    public ForgeItem(String modId, String name, ForgeRegistrator registrator, CreativeTabs tab, UnitConfig config) {
        String itemName = this.getOreDictionaryName(name);
        this.config = config;
        this.enabled = new UnitEnabled(config, itemName, true);
        this.id = new UnitId(modId, itemName);
        this.registrator = registrator;
        this.func_77655_b(itemName);
        this.func_77637_a(tab);
        ForgeRegistrator.addUnit(registrator, this);
    }

    @Nullable
    public static Item findItem(UnitId itemId) {
        return (Item)field_150901_e.func_82594_a((Object)(itemId != null ? itemId.toResLoc() : null));
    }

    @Nullable
    public static UnitId findItemId(Item item) {
        ResourceLocation location = (ResourceLocation)field_150901_e.func_177774_c((Object)item);
        return location != null ? new UnitId(location.toString()) : null;
    }

    @Override
    public String getClassDictionaryName() {
        return this.getClass().getSimpleName().toLowerCase(Locale.ENGLISH);
    }

    public String toString() {
        return ForgeItem.class.getSimpleName() + Args.group(Args.get("status", IForgeUnit.getStatus(this)), Args.get("unitName", this.id.unitName), Args.get("enabled", this.isEnabled()));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.value;
    }

    @Override
    public boolean isRegistered() {
        return Item.func_150891_b((Item)this) != -1;
    }

    @Override
    public void onInit() {
    }

    @Override
    public boolean isReadyToRegister() {
        return true;
    }

    @Override
    public UnitId getId() {
        return this.id;
    }

    @Override
    public ForgeConfig getConfig() {
        return this.config;
    }

    public static void damageItem(int damage, ItemStack stack, EntityLivingBase entity, boolean destroyBroken) {
        EntityPlayer player;
        EntityPlayer entityPlayer = player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        if (player != null && player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (stack != null && stack.func_77984_f()) {
            if (stack.func_96631_a(damage, CommonMath.random)) {
                stack.func_77964_b(stack.func_77958_k());
            }
            if (destroyBroken && ForgeItem.isBroken(stack)) {
                entity.func_70669_a(stack);
                if (stack.field_77994_a > 0) {
                    --stack.field_77994_a;
                }
                stack.func_77964_b(0);
                if (player != null) {
                    player.func_71064_a(StatList.func_188059_c((Item)stack.func_77973_b()), 1);
                }
            }
        }
    }

    public static boolean isBroken(ItemStack stack) {
        return stack == null || stack.func_77952_i() == stack.func_77958_k();
    }

    public static boolean notBroken(ItemStack stack) {
        return !ForgeItem.isBroken(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onInitClient() {
        this.getRegistrator().registerItemModel(this);
    }

    public static boolean hasNBT(ItemStack stack) {
        return stack != null && stack.func_77942_o();
    }

    public static void ensureHasNBT(ItemStack stack) {
        if (stack != null && !ForgeItem.hasNBT(stack)) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    @Override
    public ForgeRegistrator getRegistrator() {
        return this.registrator;
    }
}

