/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.ForgeWorld;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.regs.ForgeRegistrator;
import com.endertech.minecraft.forge.regs.INeedToRegister;
import com.endertech.minecraft.forge.units.UnitId;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IForgeUnit
extends INeedToRegister,
IHaveConfig {
    public static String getStatus(IForgeUnit unit) {
        if (unit != null) {
            if (unit.isEnabled()) {
                if (unit.isReadyToRegister()) {
                    return "OK";
                }
                return "NOT READY";
            }
            return "DISABLED";
        }
        return "unit is NULL!";
    }

    default public String getClassDictionaryName() {
        return CommonString.decapitalizeFirstChar(this.getClass().getSimpleName());
    }

    default public String getOreDictionaryName(String name) {
        return this.getClassDictionaryName() + CommonString.capitalizedFirstChar(name);
    }

    default public boolean isServerSide(World world) {
        return ForgeWorld.isServerSide(world);
    }

    default public boolean isClientSide(World world) {
        return ForgeWorld.isClientSide(world);
    }

    public UnitId getId();

    public boolean isEnabled();

    public boolean isRegistered();

    public void onInit();

    @SideOnly(value=Side.CLIENT)
    public void onInitClient();

    public ForgeRegistrator getRegistrator();
}

