/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.units.ForgeBlock;
import com.endertech.minecraft.forge.units.ForgeItem;
import com.endertech.minecraft.forge.units.UnitId;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RelatedUnit
implements IHaveConfig {
    protected final ForgeConfig config;
    public final UnitId id;
    private Block block = null;
    private Item item = null;

    public RelatedUnit(String id) {
        this(null, null, id);
    }

    public RelatedUnit(ForgeConfig config, String category, String id) {
        this.config = config;
        id = ForgeConfig.getStr(config, this.expandCategory(category), "id", id, "Id is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too.\nIn addition you may use '*' char as meta value to specify all possible values.\nOr you may use just NAME in ore dictionary format (examples: oreGold, gemDiamond, blockGrass)\n Also you may use just ore dictionary name.");
        this.id = new UnitId(id);
    }

    @Nullable
    public Block getBlock() {
        if (this.block == null) {
            ItemStack stack;
            this.block = ForgeBlock.findBlock(this.id);
            if (this.block == null && (stack = ForgeItem.getItemStackFromOreDict(this.id.unitName, 1)) != null) {
                this.block = Block.func_149634_a((Item)stack.func_77973_b());
            }
        }
        return this.block;
    }

    @Nullable
    public Item getItem() {
        if (this.item == null) {
            ItemStack stack;
            this.item = ForgeItem.findItem(this.id);
            if (this.item == null && (stack = ForgeItem.getItemStackFromOreDict(this.id.unitName, 1)) != null) {
                this.item = stack.func_77973_b();
            }
        }
        return this.item;
    }

    public String getStatus() {
        return this.isRegistered() ? "OK" : "NOT REGISTERED";
    }

    public boolean isRegistered() {
        return this.getBlock() != null || this.getItem() != null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Args.group(Args.get("status", this.getStatus()), Args.get("id", this.id), Args.get("block", this.block), Args.get("item", this.item));
    }

    @Override
    public ForgeConfig getConfig() {
        return this.config;
    }
}

