/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.common.CommonString;
import java.util.StringJoiner;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;

public class UnitId {
    public static final String FORMAT_FULL = "<modId:unitName:meta>";
    public static final String DESCRIPTION = "Id is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too.\nIn addition you may use '*' char as meta value to specify all possible values.\nOr you may use just NAME in ore dictionary format (examples: oreGold, gemDiamond, blockGrass)";
    public static final String DELIMITER = ":";
    public static final String MOD_ID_MINECRAFT = "minecraft";
    public static final String META_ALL_CHAR = "*";
    public static final int META_ALL_INT = Short.MAX_VALUE;
    public static final int META_DEFAULT = 0;
    public final String modId;
    public final String unitName;
    public final int meta;

    public UnitId(String modId, String unitName, int meta) {
        this.modId = modId;
        this.unitName = unitName;
        this.meta = meta;
    }

    public UnitId(String modId, String unitName) {
        this(modId, unitName, 0);
    }

    public UnitId(String id) {
        this(UnitId.getModId(id), UnitId.getUnitName(id), UnitId.getMetaData(id));
    }

    public UnitId(Enum<?> e) {
        this(String.valueOf(e).replace("$", DELIMITER));
    }

    protected static String getIdSegment(String id, Segments segment) {
        String[] parts = UnitId.ensureFullId(id).split(DELIMITER);
        return parts[segment.ordinal()].trim();
    }

    public static boolean isNullOrEmpty(UnitId unitId) {
        return unitId == null || CommonString.isNullOrEmpty(unitId.modId) || CommonString.isNullOrEmpty(unitId.unitName);
    }

    public static UnitId parseId(String id) {
        return new UnitId(id);
    }

    public static UnitId parseId(Enum<?> e) {
        return new UnitId(e);
    }

    public static String ensureFullId(String id) {
        if (!UnitId.hasMetaData(id)) {
            id = String.join((CharSequence)DELIMITER, id, String.valueOf(0));
        }
        if (id.split(DELIMITER).length < Segments.values().length) {
            id = String.join((CharSequence)DELIMITER, MOD_ID_MINECRAFT, id);
        }
        return id;
    }

    public static String getModId(String id) {
        return UnitId.getIdSegment(id, Segments.modId);
    }

    public static String getUnitName(String id) {
        return UnitId.getIdSegment(id, Segments.unitName);
    }

    public static int getMetaData(String id) {
        if (UnitId.hasMetaData(id)) {
            String metaData = UnitId.getIdSegment(id, Segments.meta);
            return metaData == META_ALL_CHAR ? Short.MAX_VALUE : Integer.parseInt(metaData);
        }
        return 0;
    }

    public static boolean hasMetaData(String id) {
        String[] parts = id.split(DELIMITER);
        if (parts.length > 1) {
            String metaData = parts[parts.length - 1].trim();
            return metaData == META_ALL_CHAR || CommonString.allCharsAreDigits(metaData);
        }
        return false;
    }

    public String getMetaData() {
        return this.meta == Short.MAX_VALUE ? META_ALL_CHAR : String.valueOf(this.meta);
    }

    public String toString() {
        return String.join((CharSequence)DELIMITER, this.modId, this.unitName, this.getMetaData());
    }

    public String toString_NoDefaults() {
        StringJoiner joiner = new StringJoiner(DELIMITER);
        if (this.modId != MOD_ID_MINECRAFT) {
            joiner.add(this.modId);
        }
        joiner.add(this.unitName);
        if (this.meta != 0) {
            joiner.add(this.getMetaData());
        }
        return joiner.toString();
    }

    public String toString_NoMeta() {
        return String.join((CharSequence)DELIMITER, this.modId, this.unitName);
    }

    public String toString_MetaAll() {
        return String.join((CharSequence)DELIMITER, this.modId, this.unitName, META_ALL_CHAR);
    }

    public ResourceLocation toResLoc() {
        return new ResourceLocation(this.modId, this.unitName);
    }

    public ModelResourceLocation toModelResLoc_Inventory() {
        return new ModelResourceLocation(this.toResLoc(), "inventory");
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnitId) {
            UnitId id = (UnitId)obj;
            return this.modId == id.modId && this.unitName == id.unitName && this.meta == id.meta;
        }
        return super.equals(obj);
    }

    public static enum Segments {
        modId,
        unitName,
        meta;

    }
}

