/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.airhop.handler;

import com.fuzs.airhop.capability.CapabilityDispatcher;
import com.fuzs.airhop.capability.CapabilityHolder;
import com.fuzs.airhop.network.NetworkHandler;
import com.fuzs.airhop.network.messages.MessageSyncAirJump;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CommonHandler {
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END && evt.player.field_70122_E) {
            CapabilityHolder.getAirHopsCap(evt.player).resetAirHops();
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent evt) {
        EntityPlayerMP player;
        int i;
        if (evt.getEntity() instanceof EntityPlayerMP && (i = CapabilityHolder.getAirHopsCap((EntityPlayer)(player = (EntityPlayerMP)evt.getEntity())).getAirHops()) > 0) {
            NetworkHandler.sendTo(new MessageSyncAirJump(i), player);
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof EntityPlayer && !((Entity)evt.getObject()).hasCapability(CapabilityHolder.airHopsCap, null)) {
            evt.addCapability(new ResourceLocation("airhop", "air_hops"), (ICapabilityProvider)new CapabilityDispatcher());
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent evt) {
        if (evt.getModID().equals("airhop")) {
            ConfigManager.sync((String)"airhop", (Config.Type)Config.Type.INSTANCE);
        }
    }
}

