/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.airhop.handler;

import com.fuzs.airhop.util.EnumArmorType;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.common.config.Config;

@Config(modid="airhop")
public class ConfigHandler {
    @Config.Name(value="enchantment")
    @Config.RequiresMcRestart
    public static EnchantmentConfig enchantmentConfig = new EnchantmentConfig();
    @Config.Name(value="Reset Fall Distance")
    @Config.Comment(value={"Reset the fall distance on every air hop. Otherwise each air hop only decreases it by the default jump height."})
    public static boolean resetFallDistance = false;
    @Config.Name(value="Prioritise Over Elytra")
    @Config.Comment(value={"When wearing an elytra; don't use it when there are air hops left. Sneaking inverts this behaviour in-game."})
    public static boolean invertElytra = false;
    @Config.Name(value="Summon Cloud Puff")
    @Config.Comment(value={"Summon a small particle cloud at every position the player air hops from."})
    public static boolean summonCloud = true;
    @Config.Name(value="Disable On Hungry")
    @Config.Comment(value={"Block the air hop enchantment from functioning when the player is too hungry."})
    public static boolean f1BlockOnHungry = false;
    @Config.Name(value="Food Threshold")
    @Config.Comment(value={"Amount of food the player needs to surpass in case \"Disable On Hungry\" is enabled."})
    @Config.RangeInt(min=0, max=20)
    public static int foodThreshold = 6;
    @Config.Name(value="Hop Exhaustion")
    @Config.Comment(value={"Exhaustion multiplier per air hop compared to normal jumps."})
    @Config.RangeDouble(min=0.0)
    public static double hopExhaustion = 4.0;

    public static class EnchantmentConfig {
        @Config.Name(value="Enchantment Rarity")
        @Config.Comment(value={"Rarity of this enchantment."})
        public Enchantment.Rarity rarity = Enchantment.Rarity.RARE;
        @Config.Name(value="Enchantment Type")
        @Config.Comment(value={"Defines the piece of armor this enchantment can be applied to. If \"ALL\" is used, the levels on all armor pieces will be combined."})
        public EnumArmorType type = EnumArmorType.ALL;
        @Config.Name(value="Maximum Level")
        @Config.Comment(value={"Maximum level for this enchantment. Each level provides one additional air hop."})
        @Config.RangeInt(min=0)
        public int maxLevel = 3;
        @Config.Name(value="Treasure Enchantment")
        @Config.Comment(value={"Makes the enchantment unobtainable from enchanting tables. It is only available on items from loot chests, fishing and villager trading."})
        public boolean treasureEnchantment = true;
    }
}

