/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.airhop.common;

import com.fuzs.airhop.capability.AirHopsCapability;
import com.fuzs.airhop.capability.CapabilityDispatcher;
import com.fuzs.airhop.capability.CapabilityHolder;
import com.fuzs.airhop.network.NetworkHandler;
import com.fuzs.airhop.network.message.AirHopMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SyncCapabilityHandler {
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END && evt.player.field_70122_E) {
            evt.player.getCapability(CapabilityHolder.airHopsCap).ifPresent(AirHopsCapability::resetAirHops);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent evt) {
        ServerPlayerEntity player;
        int jumps;
        if (evt.getEntity() instanceof ServerPlayerEntity && (jumps = ((Integer)(player = (ServerPlayerEntity)evt.getEntity()).getCapability(CapabilityHolder.airHopsCap).map(AirHopsCapability::getAirHops).orElse((Object)0)).intValue()) > 0) {
            NetworkHandler.sendTo(new AirHopMessage(new AirHopMessage.AirHopMessageData(jumps)), player);
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof PlayerEntity && !((Entity)evt.getObject()).getCapability(CapabilityHolder.airHopsCap).isPresent()) {
            evt.addCapability(new ResourceLocation("airhop", "air_hops"), (ICapabilityProvider)new CapabilityDispatcher());
        }
    }
}

