/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.airhop.network.message;

import com.fuzs.airhop.capability.CapabilityHolder;
import com.fuzs.airhop.common.helper.PerformJumpHelper;
import com.fuzs.airhop.config.ConfigBuildHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraftforge.fml.network.NetworkEvent;

public class AirHopMessage {
    private final AirHopMessageData[] data;

    public AirHopMessage(AirHopMessageData ... data) {
        this.data = data;
    }

    public static void writePacketData(AirHopMessage message, PacketBuffer buf) {
        buf.func_150787_b(message.data.length);
        for (AirHopMessageData data : message.data) {
            buf.writeByte(data.getHops());
        }
    }

    public static AirHopMessage readPacketData(PacketBuffer buf) {
        int size = buf.func_150792_a();
        AirHopMessageData[] data = new AirHopMessageData[size];
        for (int i = 0; i < size; ++i) {
            short type = buf.readUnsignedByte();
            data[i] = new AirHopMessageData(type);
        }
        return new AirHopMessage(data);
    }

    public static void processPacket(AirHopMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            for (AirHopMessageData data : message.data) {
                ClientPlayerEntity player;
                if (data.getHops() == 0) {
                    player = ((NetworkEvent.Context)ctx.get()).getSender();
                    if (player == null || !new PerformJumpHelper().doJump((PlayerEntity)player, (Boolean)ConfigBuildHandler.GENERAL_CONFIG.invertElytra.get() == false) || !((Boolean)ConfigBuildHandler.GENERAL_CONFIG.summonCloud.get()).booleanValue()) continue;
                    player.func_71121_q().func_195598_a((IParticleData)ParticleTypes.field_197613_f, player.field_70165_t, player.field_70163_u, player.field_70161_v, 15, 0.25, 0.0, 0.25, (double)0.01f);
                    continue;
                }
                player = Minecraft.func_71410_x().field_71439_g;
                if (player == null || player.field_70122_E) continue;
                player.getCapability(CapabilityHolder.airHopsCap).ifPresent(it -> it.setAirHops(data.getHops()));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static class AirHopMessageData {
        private final int hops;

        public AirHopMessageData(int hops) {
            this.hops = hops;
        }

        private int getHops() {
            return this.hops;
        }
    }
}

