/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.airhop.capability.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityDispatcher<T extends INBTSerializable<CompoundNBT>>
implements ICapabilitySerializable<CompoundNBT> {
    private final Capability<T> capability;
    private final T storage;

    public CapabilityDispatcher(T storage, Capability<T> capability) {
        this.storage = storage;
        this.capability = capability;
    }

    @Nonnull
    public <S> LazyOptional<S> getCapability(@Nonnull Capability<S> capability, @Nullable Direction facing) {
        return capability == this.capability ? LazyOptional.of(() -> this.storage) : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)this.storage.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.storage.deserializeNBT((INBT)nbt);
    }
}

