/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.airhop.common;

import com.fuzs.airhop.capability.AirHopCapabilities;
import com.fuzs.airhop.capability.storage.AirHopsCapability;
import com.fuzs.airhop.network.NetworkHandler;
import com.fuzs.airhop.network.message.SyncHopMessage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SyncCapabilityHandler {
    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent evt) {
        ServerPlayerEntity player;
        int jumps;
        if (evt.getEntity() instanceof ServerPlayerEntity && (jumps = (player = (ServerPlayerEntity)evt.getEntity()).getCapability(AirHopCapabilities.AIR_HOPS).map(AirHopsCapability::getAirHops).orElse(0).intValue()) > 0) {
            NetworkHandler.getInstance().sendTo(new SyncHopMessage(jumps), player);
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent evt) {
        if (evt.getEntityLiving() instanceof PlayerEntity) {
            evt.setDistance(this.onGroundHit((PlayerEntity)evt.getEntityLiving(), evt.getDistance()));
        }
    }

    @SubscribeEvent
    public void onPlayerFall(PlayerFlyableFallEvent evt) {
        evt.setDistance(this.onGroundHit(evt.getPlayer(), evt.getDistance()));
    }

    private float onGroundHit(PlayerEntity player, float fallDistance) {
        int hops = player.getCapability(AirHopCapabilities.AIR_HOPS).map(AirHopsCapability::getAirHops).orElse(0);
        player.getCapability(AirHopCapabilities.AIR_HOPS).ifPresent(AirHopsCapability::resetAirHops);
        if (hops > 0) {
            float f = 1.25f;
            if (player.func_70644_a(Effects.field_76430_j)) {
                f += 0.6875f * ((float)player.func_70660_b(Effects.field_76430_j).func_76458_c() + 1.0f);
            }
            return Math.max(0.0f, fallDistance - (float)hops * f);
        }
        return fallDistance;
    }
}

