/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.airhop.network;

import com.fuzs.airhop.AirHop;
import com.fuzs.airhop.network.message.IMessage;
import com.fuzs.airhop.network.message.SimpleHopMessage;
import com.fuzs.airhop.network.message.SyncHopMessage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public final class NetworkHandler {
    private static final NetworkHandler INSTANCE = new NetworkHandler();
    private final String PROTOCOL_VERSION = Integer.toString(1);
    private final SimpleChannel MAIN_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("airhop", "main_channel"), () -> this.PROTOCOL_VERSION, this.PROTOCOL_VERSION::equals, this.PROTOCOL_VERSION::equals);
    private int discriminator;

    private NetworkHandler() {
    }

    public void init() {
        this.registerMessage(new SimpleHopMessage());
        this.registerMessage(new SyncHopMessage());
    }

    private <T extends IMessage> void registerMessage(T message) {
        this.MAIN_CHANNEL.registerMessage(this.discriminator++, message.getClass(), IMessage::writePacketData, message::readPacketData, (msg, side) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)side.get();
            ctx.setPacketHandled(true);
            if (ctx.getDirection().getOriginationSide().equals((Object)msg.getExecutionSide())) {
                AirHop.LOGGER.error("Receiving {} at wrong side!", (Object)msg.getClass().getSimpleName());
                return;
            }
            ctx.enqueueWork(() -> msg.processPacket((PlayerEntity)ctx.getSender()));
        });
    }

    public void sendToServer(IMessage message) {
        this.MAIN_CHANNEL.sendToServer((Object)message);
    }

    public void sendTo(IMessage message, ServerPlayerEntity player) {
        this.MAIN_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }

    public void sendToAll(IMessage message) {
        this.MAIN_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)message);
    }

    public static NetworkHandler getInstance() {
        return INSTANCE;
    }
}

