/*
 * Decompiled with CFR 0.152.
 */
package archicraft.block;

import archicraft.common.Archicraft;
import archicraft.generic.block.GenericBlock;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLuminary
extends GenericBlock {
    protected final AxisAlignedBB aabb_down;
    protected final AxisAlignedBB aabb_north;
    protected final AxisAlignedBB aabb_east;
    protected final AxisAlignedBB aabb_south;
    protected final AxisAlignedBB aabb_west;
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(@Nullable EnumFacing p_apply_1_) {
            return p_apply_1_ != EnumFacing.UP;
        }
    });

    public BlockLuminary(Material mat, String name, SoundType sound, AxisAlignedBB[] aabb) {
        super(mat, name, 0.0f, 0.0f, 15.0f, sound);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN));
        this.aabb_down = aabb[0];
        this.aabb_north = aabb[1];
        this.aabb_east = aabb[2];
        this.aabb_south = aabb[3];
        this.aabb_west = aabb[4];
    }

    public BlockLuminary(Material mat, String name, SoundType sound) {
        this(mat, name, sound, new AxisAlignedBB[]{new AxisAlignedBB((double)Archicraft.PIXEL_TO_FLOAT[4], (double)Archicraft.PIXEL_TO_FLOAT[14], (double)Archicraft.PIXEL_TO_FLOAT[4], (double)Archicraft.PIXEL_TO_FLOAT[12], 1.0, (double)Archicraft.PIXEL_TO_FLOAT[12]), new AxisAlignedBB((double)Archicraft.PIXEL_TO_FLOAT[4], (double)Archicraft.PIXEL_TO_FLOAT[4], (double)Archicraft.PIXEL_TO_FLOAT[14], (double)Archicraft.PIXEL_TO_FLOAT[12], (double)Archicraft.PIXEL_TO_FLOAT[12], 1.0), new AxisAlignedBB(0.0, (double)Archicraft.PIXEL_TO_FLOAT[4], (double)Archicraft.PIXEL_TO_FLOAT[4], (double)Archicraft.PIXEL_TO_FLOAT[2], (double)Archicraft.PIXEL_TO_FLOAT[12], (double)Archicraft.PIXEL_TO_FLOAT[12]), new AxisAlignedBB((double)Archicraft.PIXEL_TO_FLOAT[4], (double)Archicraft.PIXEL_TO_FLOAT[4], 0.0, (double)Archicraft.PIXEL_TO_FLOAT[12], (double)Archicraft.PIXEL_TO_FLOAT[12], (double)Archicraft.PIXEL_TO_FLOAT[2]), new AxisAlignedBB((double)Archicraft.PIXEL_TO_FLOAT[14], (double)Archicraft.PIXEL_TO_FLOAT[4], (double)Archicraft.PIXEL_TO_FLOAT[4], 1.0, (double)Archicraft.PIXEL_TO_FLOAT[12], (double)Archicraft.PIXEL_TO_FLOAT[12])});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return this.aabb_east;
            }
            case WEST: {
                return this.aabb_west;
            }
            case SOUTH: {
                return this.aabb_south;
            }
            case NORTH: {
                return this.aabb_north;
            }
        }
        return this.aabb_down;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, facing);
        return !facing.equals((Object)EnumFacing.UP) && iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, facing) == BlockFaceShape.SOLID;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        switch (meta) {
            case 1: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
                break;
            }
            case 2: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
                break;
            }
            case 3: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
                break;
            }
            case 4: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
                break;
            }
            default: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN);
            }
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return 1;
            }
            case WEST: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
            case NORTH: {
                return 4;
            }
        }
        return 5;
    }
}

