/*
 * Decompiled with CFR 0.152.
 */
package archicraft.generic.block;

import archicraft.common.Archicraft;
import archicraft.generic.block.GenericBlock;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GenericDoor
extends GenericBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");
    public static final PropertyBool UPPER = PropertyBool.func_177716_a((String)"upper");
    protected boolean field_149785_s;

    public GenericDoor(Material mat, String name, float hard, float res, SoundType sound, boolean trans) {
        super(mat, name, hard, res, sound);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)));
        this.field_149785_s = trans;
    }

    public GenericDoor(Material mat, String name, float hard, float res, SoundType sound) {
        this(mat, name, hard, res, sound, false);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return (Boolean)state.func_177229_b((IProperty)UPPER) == true ? Items.field_190931_a : Item.func_150898_a((Block)this);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.field_149785_s ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT_MIPPED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if ((EnumFacing)state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH || (EnumFacing)state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            return new AxisAlignedBB((double)Archicraft.PIXEL_TO_FLOAT[7], 0.0, 0.0, (double)Archicraft.PIXEL_TO_FLOAT[9], 1.0, 1.0);
        }
        return new AxisAlignedBB(0.0, 0.0, (double)Archicraft.PIXEL_TO_FLOAT[7], 1.0, 1.0, (double)Archicraft.PIXEL_TO_FLOAT[9]);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            return field_185506_k;
        }
        if ((EnumFacing)state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH || (EnumFacing)state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            return new AxisAlignedBB((double)Archicraft.PIXEL_TO_FLOAT[7], 0.0, 0.0, (double)Archicraft.PIXEL_TO_FLOAT[9], 1.0, 1.0);
        }
        return new AxisAlignedBB(0.0, 0.0, (double)Archicraft.PIXEL_TO_FLOAT[7], 1.0, 1.0, (double)Archicraft.PIXEL_TO_FLOAT[9]);
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)OPEN);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (pos.func_177956_o() >= worldIn.func_72800_K() - 1) {
            return false;
        }
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        return (state.func_185896_q() || state.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID) && super.func_176196_c(worldIn, pos) && super.func_176196_c(worldIn, pos.func_177984_a());
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing.func_176734_d());
        }
        return this.func_176223_P();
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, facing);
        return !facing.equals((Object)EnumFacing.UP) && !facing.equals((Object)EnumFacing.DOWN) && iblockstate.func_193401_d((IBlockAccess)worldIn, blockpos, facing) == BlockFaceShape.SOLID;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)FACING, world.func_180495_p(pos).func_177229_b((IProperty)FACING)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(true)));
    }

    private int getCloseSound() {
        return 1012;
    }

    private int getOpenSound() {
        return 1006;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        world.func_175656_a(pos, state.func_177231_a((IProperty)OPEN));
        if (((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue() && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            world.func_175704_b(pos.func_177977_b(), pos);
            world.func_175656_a(pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()).func_177231_a((IProperty)OPEN));
        } else if (!((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue() && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_175704_b(pos, pos.func_177984_a());
            world.func_175656_a(pos.func_177984_a(), world.func_180495_p(pos.func_177984_a()).func_177231_a((IProperty)OPEN));
        }
        world.func_180498_a(playerIn, (Boolean)state.func_177229_b((IProperty)OPEN) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        return true;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue() && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            worldIn.func_175698_g(pos.func_177977_b());
        } else if (!((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue() && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            worldIn.func_175698_g(pos.func_177984_a());
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, OPEN, UPPER});
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        switch (meta) {
            case 0: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
                break;
            }
            case 1: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
                break;
            }
            case 2: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
                break;
            }
            case 3: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
                break;
            }
            case 4: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true));
                break;
            }
            case 5: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true));
                break;
            }
            case 6: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true));
                break;
            }
            case 7: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true));
                break;
            }
            case 8: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(true));
                break;
            }
            case 9: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(true));
                break;
            }
            case 10: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(true));
                break;
            }
            case 11: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(true));
                break;
            }
            case 12: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(true));
                break;
            }
            case 13: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(true));
                break;
            }
            case 14: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(true));
                break;
            }
            case 15: {
                iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(true));
            }
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int meta;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case WEST: {
                meta = 1;
                break;
            }
            case SOUTH: {
                meta = 2;
                break;
            }
            case EAST: {
                meta = 3;
                break;
            }
            default: {
                meta = 0;
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            meta += 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)UPPER)).booleanValue()) {
            meta += 8;
        }
        return meta;
    }
}

