/*
 * Decompiled with CFR 0.152.
 */
package archicraft.generic.block;

import archicraft.generic.block.GenericPartialBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GenericOrientableBlock
extends GenericPartialBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public GenericOrientableBlock(Material mat, String name, float hard, float res, AxisAlignedBB boundingBox, float light, SoundType sound) {
        super(mat, name, hard, res, boundingBox, light, sound);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public GenericOrientableBlock(Material mat, String name, float hard, float res, AxisAlignedBB boundingBox, SoundType sound) {
        this(mat, name, hard, res, boundingBox, 0.0f, sound);
    }

    public GenericOrientableBlock(Material mat, String name, float hard, float res, AxisAlignedBB boundingBox, float light) {
        this(mat, name, hard, res, boundingBox, light, SoundType.field_185851_d);
    }

    public GenericOrientableBlock(Material mat, String name, float hard, float res, AxisAlignedBB boundingBox) {
        this(mat, name, hard, res, boundingBox, 0.0f, SoundType.field_185851_d);
    }

    public GenericOrientableBlock(Material mat, String name, float hard, float res, float light, SoundType sound) {
        this(mat, name, hard, res, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), light, sound);
    }

    public GenericOrientableBlock(Material mat, String name, float hard, float res, SoundType sound) {
        this(mat, name, hard, res, 0.0f, sound);
    }

    public GenericOrientableBlock(Material mat, String name, float hard, float res, float light) {
        this(mat, name, hard, res, light, SoundType.field_185851_d);
    }

    public GenericOrientableBlock(Material mat, String name, float hard, float res) {
        this(mat, name, hard, res, 0.0f, SoundType.field_185851_d);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }
}

