/*
 * Decompiled with CFR 0.152.
 */
package archicraft.generic.tileEntity;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public abstract class GenericTileEntityBuilder
extends TileEntity
implements ITickable {
    protected int rest = 20;
    protected boolean building = false;
    protected int level = 0;
    protected char direction = (char)110;
    protected final Item[] resources;
    protected final int[] metaResources;
    protected final int[] cantResources;
    protected final int width;
    protected final int height;
    protected final int deep;
    protected int[] inv;

    public GenericTileEntityBuilder(Item[] resources, int[] metaResources, int[] cantResources, int width, int deep, int height) {
        this.resources = resources;
        this.metaResources = metaResources;
        this.cantResources = cantResources;
        this.inv = new int[resources.length];
        this.width = width;
        this.height = height;
        this.deep = deep;
    }

    public static void register() {
        GameRegistry.registerTileEntity(GenericTileEntityBuilder.class, (ResourceLocation)new ResourceLocation("GenericTileEntityBuilder"));
    }

    public int[] getInventory() {
        return this.inv;
    }

    public int getInventoryIndex(int index) {
        return this.inv[index];
    }

    public char getDirection() {
        return this.direction;
    }

    public void setDirection(char dir) {
        this.direction = dir;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDeep() {
        return this.deep;
    }

    protected void build() {
        if (this.level < this.height) {
            this.buildLayer(this.level, this.getCurrentBlueprint().split("[|]")[this.level], this.getMaterials(), this.getCurrentMetadata().split("[|]")[this.level]);
            ++this.level;
        } else {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    public abstract Block[] getMaterials();

    public abstract String getCurrentBlueprint();

    public abstract String getCurrentMetadata();

    public static String decompressData(String input) {
        String[] rows = input.split(",");
        String out = "";
        for (int i = 0; i < rows.length; ++i) {
            String[] current = rows[i].split(":");
            if (current.length == 1) {
                out = out + current[0];
            } else {
                int num = Integer.parseInt(current[1]);
                for (int j = 0; j < num; ++j) {
                    out = out + current[0];
                    if (j >= num - 1) continue;
                    out = out + ",";
                }
            }
            if (i >= rows.length - 1) continue;
            out = out + ",";
        }
        return out;
    }

    protected void buildLayer(int level, String blueprint, Block[] materials, String metas) {
        String[] rows = blueprint.split(";");
        String[] metarows = metas.split(";");
        for (int i = 0; i < rows.length; ++i) {
            String[] blocks = GenericTileEntityBuilder.decompressData(rows[i]).split(",");
            String[] metablocks = GenericTileEntityBuilder.decompressData(metarows[i]).split(",");
            BlockPos position = this.field_174879_c.func_177981_b(level);
            switch (this.direction) {
                case 'a': {
                    position = position.func_177965_g(i + 1);
                    break;
                }
                case 'b': {
                    position = position.func_177970_e(i + 1);
                    break;
                }
                case 'c': {
                    position = position.func_177985_f(i + 1);
                    break;
                }
                case 'd': {
                    position = position.func_177964_d(i + 1);
                }
            }
            block13: for (int j = 0; j < blocks.length; ++j) {
                String act = blocks[j];
                if (act.compareTo("0") != 0 && this.field_145850_b.func_180495_p(position).func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, position)) {
                    this.field_145850_b.func_175656_a(position, materials[Integer.parseInt(act)].func_176203_a(Integer.parseInt(metablocks[j])));
                }
                switch (this.direction) {
                    case 'a': {
                        position = position.func_177968_d();
                        continue block13;
                    }
                    case 'b': {
                        position = position.func_177976_e();
                        continue block13;
                    }
                    case 'c': {
                        position = position.func_177978_c();
                        continue block13;
                    }
                    case 'd': {
                        position = position.func_177974_f();
                    }
                }
            }
        }
    }

    protected boolean checkMaterials() {
        boolean toret = false;
        TileEntityChest chest = null;
        switch (this.direction) {
            case 'c': {
                chest = (TileEntityChest)this.field_145850_b.func_175625_s(this.field_174879_c.func_177974_f());
                break;
            }
            case 'd': {
                chest = (TileEntityChest)this.field_145850_b.func_175625_s(this.field_174879_c.func_177968_d());
                break;
            }
            case 'a': {
                chest = (TileEntityChest)this.field_145850_b.func_175625_s(this.field_174879_c.func_177976_e());
                break;
            }
            case 'b': {
                chest = (TileEntityChest)this.field_145850_b.func_175625_s(this.field_174879_c.func_177978_c());
            }
        }
        if (chest != null) {
            if (chest.func_70301_a(0) != null && chest.func_70301_a(0).func_77973_b() == Item.func_150898_a((Block)Blocks.field_150357_h)) {
                return true;
            }
            toret = true;
            for (int i = 0; i < this.resources.length; ++i) {
                int cant = 0;
                cant = this.metaResources[i] > -1 ? this.getFromChest(chest, this.resources[i], this.metaResources[i], this.cantResources[i] - this.inv[i]) : (this.resources[i] == Item.func_150898_a((Block)Blocks.field_150344_f) ? this.getFromChest(chest, OreDictionary.getOreID((String)"plankWood"), this.cantResources[i] - this.inv[i]) : (this.resources[i] == Item.func_150898_a((Block)Blocks.field_150359_w) ? this.getFromChest(chest, OreDictionary.getOreID((String)"blockGlass"), this.cantResources[i] - this.inv[i]) : (this.resources[i] == Item.func_150898_a((Block)Blocks.field_150354_m) ? this.getFromChest(chest, OreDictionary.getOreID((String)"sand"), this.cantResources[i] - this.inv[i]) : (this.resources[i] == Item.func_150898_a((Block)Blocks.field_150351_n) ? this.getFromChest(chest, OreDictionary.getOreID((String)"gravel"), this.cantResources[i] - this.inv[i]) : this.getFromChest(chest, this.resources[i], this.cantResources[i] - this.inv[i])))));
                if (cant > 0) {
                    int n = i;
                    this.inv[n] = this.inv[n] + cant;
                    this.sendUpdates();
                }
                if (this.inv[i] >= this.cantResources[i]) continue;
                toret = false;
            }
        }
        return toret;
    }

    protected int getFromChest(TileEntityChest chest, Item itm, int meta, int needed) {
        int cant = 0;
        for (int i = 0; i < chest.func_70302_i_() && cant < needed; ++i) {
            ItemStack it = chest.func_70301_a(i);
            if (it.func_77973_b() != itm || it.func_77960_j() != meta) continue;
            if (it.func_190916_E() <= needed - cant) {
                cant += it.func_190916_E();
                chest.func_70304_b(i);
                continue;
            }
            chest.func_70298_a(i, needed - cant);
            cant = needed;
        }
        return cant;
    }

    protected int getFromChest(TileEntityChest chest, Item itm, int needed) {
        int cant = 0;
        for (int i = 0; i < chest.func_70302_i_() && cant < needed; ++i) {
            ItemStack it = chest.func_70301_a(i);
            if (it.func_77973_b() != itm) continue;
            if (it.func_190916_E() <= needed - cant) {
                cant += it.func_190916_E();
                chest.func_70304_b(i);
                continue;
            }
            chest.func_70298_a(i, needed - cant);
            cant = needed;
        }
        return cant;
    }

    protected int getFromChest(TileEntityChest chest, int oreID, int needed) {
        int cant = 0;
        block0: for (int i = 0; i < chest.func_70302_i_() && cant < needed; ++i) {
            int[] listID;
            ItemStack it = chest.func_70301_a(i);
            if (it.func_190926_b()) continue;
            for (int id : listID = OreDictionary.getOreIDs((ItemStack)it)) {
                if (id != oreID) continue;
                if (it.func_190916_E() <= needed - cant) {
                    cant += it.func_190916_E();
                    chest.func_70304_b(i);
                    continue block0;
                }
                chest.func_70298_a(i, needed - cant);
                cant = needed;
                continue block0;
            }
        }
        return cant;
    }

    public void func_73660_a() {
        if (this.rest > 0) {
            --this.rest;
            if (this.rest == 0) {
                if (this.building) {
                    this.build();
                    this.rest = 20;
                } else {
                    this.direction = this.field_145850_b.func_180495_p(this.field_174879_c.func_177974_f()).func_177230_c() == Blocks.field_150486_ae ? (char)99 : (this.field_145850_b.func_180495_p(this.field_174879_c.func_177968_d()).func_177230_c() == Blocks.field_150486_ae ? (char)100 : (this.field_145850_b.func_180495_p(this.field_174879_c.func_177976_e()).func_177230_c() == Blocks.field_150486_ae ? (char)97 : (this.field_145850_b.func_180495_p(this.field_174879_c.func_177978_c()).func_177230_c() == Blocks.field_150486_ae ? (char)98 : (char)110)));
                    if (this.direction != 'n' && this.checkMaterials()) {
                        this.inv = new int[this.resources.length];
                        this.building = true;
                    }
                    this.rest = 100;
                }
            }
        }
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public void dropInventoryItems() {
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack itemstack = new ItemStack(this.resources[i], this.inv[i], this.metaResources[i] < 0 ? 0 : this.metaResources[i]);
            if (itemstack.func_190926_b()) continue;
            this.spawnItemStack(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), itemstack);
        }
    }

    protected void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        Random rand = new Random();
        float f = rand.nextFloat() * 0.8f + 0.1f;
        float f1 = rand.nextFloat() * 0.8f + 0.1f;
        float f2 = rand.nextFloat() * 0.8f + 0.1f;
        while (!stack.func_190926_b()) {
            EntityItem entityitem = new EntityItem(worldIn, x + (double)f, y + (double)f1, z + (double)f2, stack.func_77979_a(rand.nextInt(21) + 10));
            float f3 = 0.05f;
            entityitem.field_70159_w = rand.nextGaussian() * (double)0.05f;
            entityitem.field_70181_x = rand.nextGaussian() * (double)0.05f + (double)0.2f;
            entityitem.field_70179_y = rand.nextGaussian() * (double)0.05f;
            worldIn.func_72838_d((Entity)entityitem);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound NBT) {
        super.func_189515_b(NBT);
        NBT.func_74768_a("rest", this.rest);
        NBT.func_74757_a("building", this.building);
        NBT.func_74768_a("level", this.level);
        NBT.func_74778_a("direction", this.direction + "");
        NBT.func_74783_a("inv", this.inv);
        return NBT;
    }

    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.rest = NBT.func_74762_e("rest");
        this.building = NBT.func_74767_n("building");
        this.level = NBT.func_74762_e("level");
        this.direction = NBT.func_74779_i("direction") != null && NBT.func_74779_i("direction").length() > 0 ? NBT.func_74779_i("direction").charAt(0) : (char)110;
        this.inv = NBT.func_74759_k("inv");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.serializeNBT());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    protected void sendUpdates() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

