/*
 * Decompiled with CFR 0.152.
 */
package archicraft.generic.tileEntity.TESR;

import archicraft.generic.tileEntity.GenericTileEntityBuilder;
import java.awt.Color;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.Vec3d;

public class TESRBuilder
extends TileEntitySpecialRenderer<GenericTileEntityBuilder> {
    protected Color color;
    protected int underwater;

    public TESRBuilder(String type) {
        this(type, 0);
    }

    public TESRBuilder(String type, int underwater) {
        switch (type) {
            case "bio": {
                this.color = new Color(127, 186, 7, 255);
                break;
            }
            case "arch": {
                this.color = new Color(0, 186, 255, 255);
                break;
            }
            case "luxark": {
                this.color = new Color(255, 145, 0, 255);
                break;
            }
            case "alqaz": {
                this.color = new Color(255, 216, 0, 255);
                break;
            }
            case "okeanos": {
                this.color = new Color(131, 185, 165, 255);
            }
        }
        this.underwater = underwater;
    }

    public void render(GenericTileEntityBuilder te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te.getDirection() != 'n') {
            Vec3d vecA = null;
            Vec3d vecB = null;
            switch (te.getDirection()) {
                case 'a': {
                    vecA = new Vec3d(x + 1.0, y, z);
                    vecB = new Vec3d(x + (double)te.getDeep() + 1.0, y + (double)te.getHeight(), z + (double)te.getWidth());
                    break;
                }
                case 'b': {
                    vecA = new Vec3d(x + 1.0, y, z + 1.0);
                    vecB = new Vec3d(x - (double)te.getWidth() + 1.0, y + (double)te.getHeight(), z + (double)te.getDeep() + 1.0);
                    break;
                }
                case 'c': {
                    vecA = new Vec3d(x, y, z + 1.0);
                    vecB = new Vec3d(x - (double)te.getDeep(), y + (double)te.getHeight(), z - (double)te.getWidth() + 1.0);
                    break;
                }
                case 'd': {
                    vecA = new Vec3d(x, y, z);
                    vecB = new Vec3d(x + (double)te.getWidth(), y + (double)te.getHeight(), z - (double)te.getDeep());
                }
            }
            this.drawBoundingBox(vecA, vecB, 2.0f);
        }
    }

    protected void drawBoundingBox(Vec3d posA, Vec3d posB, float width) {
        double hor = posA.field_72450_a + (posB.field_72450_a - posA.field_72450_a) / 2.0;
        double deep = posA.field_72449_c + (posB.field_72449_c - posA.field_72449_c) / 2.0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)this.color.getRed(), (float)this.color.getGreen(), (float)this.color.getBlue(), (float)this.color.getAlpha());
        GlStateManager.func_187441_d((float)width);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b, posA.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posB.field_72450_a, posA.field_72448_b, posA.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b, posA.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b, posB.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b, posA.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posB.field_72448_b, posA.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posB.field_72450_a, posA.field_72448_b, posA.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posB.field_72450_a, posA.field_72448_b, posB.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posB.field_72450_a, posA.field_72448_b, posA.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posB.field_72450_a, posB.field_72448_b, posA.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posB.field_72450_a, posA.field_72448_b, posB.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b, posB.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posB.field_72450_a, posA.field_72448_b, posB.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posB.field_72450_a, posB.field_72448_b, posB.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b, posB.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posB.field_72448_b, posB.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posB.field_72448_b, posA.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posB.field_72450_a, posB.field_72448_b, posA.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posB.field_72450_a, posB.field_72448_b, posA.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posB.field_72450_a, posB.field_72448_b, posB.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posB.field_72450_a, posB.field_72448_b, posB.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posB.field_72448_b, posB.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posB.field_72448_b, posB.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posB.field_72448_b, posA.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(hor, posA.field_72448_b, posA.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(hor, posB.field_72448_b, posA.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b, deep).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posA.field_72450_a, posB.field_72448_b, deep).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posB.field_72450_a, posA.field_72448_b, deep).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(posB.field_72450_a, posB.field_72448_b, deep).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(hor, posA.field_72448_b, posB.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        bufferBuilder.func_181662_b(hor, posB.field_72448_b, posB.field_72449_c).func_181669_b(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this.color.getAlpha()).func_181675_d();
        if (this.underwater > 0) {
            Color underColor = new Color(0, 102, 255, 255);
            bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b + (double)this.underwater, posA.field_72449_c).func_181669_b(underColor.getRed(), underColor.getGreen(), underColor.getBlue(), underColor.getAlpha()).func_181675_d();
            bufferBuilder.func_181662_b(posB.field_72450_a, posA.field_72448_b + (double)this.underwater, posA.field_72449_c).func_181669_b(underColor.getRed(), underColor.getGreen(), underColor.getBlue(), underColor.getAlpha()).func_181675_d();
            bufferBuilder.func_181662_b(posB.field_72450_a, posA.field_72448_b + (double)this.underwater, posA.field_72449_c).func_181669_b(underColor.getRed(), underColor.getGreen(), underColor.getBlue(), underColor.getAlpha()).func_181675_d();
            bufferBuilder.func_181662_b(posB.field_72450_a, posA.field_72448_b + (double)this.underwater, posB.field_72449_c).func_181669_b(underColor.getRed(), underColor.getGreen(), underColor.getBlue(), underColor.getAlpha()).func_181675_d();
            bufferBuilder.func_181662_b(posB.field_72450_a, posA.field_72448_b + (double)this.underwater, posB.field_72449_c).func_181669_b(underColor.getRed(), underColor.getGreen(), underColor.getBlue(), underColor.getAlpha()).func_181675_d();
            bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b + (double)this.underwater, posB.field_72449_c).func_181669_b(underColor.getRed(), underColor.getGreen(), underColor.getBlue(), underColor.getAlpha()).func_181675_d();
            bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b + (double)this.underwater, posB.field_72449_c).func_181669_b(underColor.getRed(), underColor.getGreen(), underColor.getBlue(), underColor.getAlpha()).func_181675_d();
            bufferBuilder.func_181662_b(posA.field_72450_a, posA.field_72448_b + (double)this.underwater, posA.field_72449_c).func_181669_b(underColor.getRed(), underColor.getGreen(), underColor.getBlue(), underColor.getAlpha()).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }
}

