/*
 * Decompiled with CFR 0.152.
 */
package archicraft.tileEntity.creative;

import archicraft.generic.tileEntity.GenericTileEntity;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileEntityScanner
extends GenericTileEntity {
    protected boolean scanning = false;
    protected char direction = (char)110;
    protected int width = 0;
    protected int deep = 0;
    protected int height = 0;
    protected int level = 0;
    protected ArrayList<String> mats = new ArrayList();
    protected ArrayList<Integer> cant = new ArrayList();
    protected StringBuilder blueprint = new StringBuilder();
    protected StringBuilder tempBlue = new StringBuilder();
    protected StringBuilder tempMeta = new StringBuilder();
    protected StringBuilder tempMetas = new StringBuilder();
    protected StringBuilder tempMetae = new StringBuilder();
    protected StringBuilder tempMetaw = new StringBuilder();
    protected StringBuilder meta = new StringBuilder();
    protected StringBuilder metas = new StringBuilder();
    protected StringBuilder metae = new StringBuilder();
    protected StringBuilder metaw = new StringBuilder();

    public TileEntityScanner() {
        this.mats.add(null);
        this.mats.add(Blocks.field_150350_a.getRegistryName().toString());
        this.cant.add(0);
        this.cant.add(0);
    }

    public static void register() {
        GameRegistry.registerTileEntity(TileEntityScanner.class, (ResourceLocation)new ResourceLocation("archicraft", "TileEntityScanner"));
    }

    protected void appendStringMetas(String s) {
        if (s.equals(",")) {
            this.tempMeta.append(s);
            this.tempMetas.append(s);
            this.tempMetae.append(s);
            this.tempMetaw.append(s);
        } else {
            this.meta.append(s);
            this.metas.append(s);
            this.metae.append(s);
            this.metaw.append(s);
        }
    }

    protected void appendBlockStateMetas(Block b, IBlockState bs) {
        if (b != null) {
            this.tempMeta.append(b.func_176201_c(bs));
            this.tempMetas.append(b.func_176201_c(bs.func_185907_a(Rotation.CLOCKWISE_180)));
            this.tempMetae.append(b.func_176201_c(bs.func_185907_a(Rotation.CLOCKWISE_90)));
            this.tempMetaw.append(b.func_176201_c(bs.func_185907_a(Rotation.COUNTERCLOCKWISE_90)));
        } else {
            this.tempMeta.append(0);
            this.tempMetas.append(0);
            this.tempMetae.append(0);
            this.tempMetaw.append(0);
        }
    }

    protected String compressData(StringBuilder data) {
        String[] row = data.toString().split(",");
        StringBuilder out = new StringBuilder();
        String prev = "";
        int count = 1;
        for (String c : row) {
            if (prev.equals("")) {
                prev = c;
                continue;
            }
            if (prev.equals(c)) {
                ++count;
                continue;
            }
            if (count > 1) {
                out.append(prev + ':' + count + ',');
            } else {
                out.append(prev + ',');
            }
            prev = c;
            count = 1;
        }
        if (count > 1) {
            out.append(prev + ':' + count);
        } else {
            out.append(prev);
        }
        return out.toString();
    }

    @Override
    protected void action() {
        if (!this.scanning) {
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177974_f()).func_177230_c() == Blocks.field_150357_h) {
                this.direction = (char)99;
            } else if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177968_d()).func_177230_c() == Blocks.field_150357_h) {
                this.direction = (char)100;
            } else if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177976_e()).func_177230_c() == Blocks.field_150357_h) {
                this.direction = (char)97;
            } else if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177978_c()).func_177230_c() == Blocks.field_150357_h) {
                this.direction = (char)98;
            }
            if (this.direction != 'n') {
                int i = 1;
                while (i + this.field_174879_c.func_177956_o() < 250) {
                    if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177981_b(i)).func_177230_c() == Blocks.field_150357_h) {
                        this.height = i;
                    }
                    ++i;
                }
                block1 : switch (this.direction) {
                    case 'a': {
                        for (i = 0; i < 250; ++i) {
                            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177970_e(i)).func_177230_c() != Blocks.field_150357_h) continue;
                            this.width = i;
                            break;
                        }
                        for (i = 0; i < 250; ++i) {
                            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177965_g(i)).func_177230_c() != Blocks.field_150357_h) continue;
                            this.deep = i - 1;
                            break block1;
                        }
                        break;
                    }
                    case 'b': {
                        for (i = 0; i < 250; ++i) {
                            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177985_f(i)).func_177230_c() != Blocks.field_150357_h) continue;
                            this.width = i;
                            break;
                        }
                        for (i = 0; i < 250; ++i) {
                            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177970_e(i)).func_177230_c() != Blocks.field_150357_h) continue;
                            this.deep = i - 1;
                            break block1;
                        }
                        break;
                    }
                    case 'c': {
                        for (i = 0; i < 250; ++i) {
                            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177964_d(i)).func_177230_c() != Blocks.field_150357_h) continue;
                            this.width = i;
                            break;
                        }
                        for (i = 0; i < 250; ++i) {
                            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177985_f(i)).func_177230_c() != Blocks.field_150357_h) continue;
                            this.deep = i - 1;
                            break block1;
                        }
                        break;
                    }
                    case 'd': {
                        for (i = 0; i < 250; ++i) {
                            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177965_g(i)).func_177230_c() != Blocks.field_150357_h) continue;
                            this.width = i;
                            break;
                        }
                        for (i = 0; i < 250; ++i) {
                            if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177964_d(i)).func_177230_c() != Blocks.field_150357_h) continue;
                            this.deep = i - 1;
                            break block1;
                        }
                        break;
                    }
                }
                if (this.width > 0 && this.deep > 0 && this.height > 0) {
                    this.scanning = true;
                }
            }
        } else {
            System.out.println("Scanning level: " + (this.level + 1) + " / " + this.height);
            for (int i = 1; i <= this.deep; ++i) {
                BlockPos position = this.field_174879_c.func_177981_b(this.level);
                switch (this.direction) {
                    case 'a': {
                        position = position.func_177965_g(i);
                        break;
                    }
                    case 'b': {
                        position = position.func_177970_e(i);
                        break;
                    }
                    case 'c': {
                        position = position.func_177985_f(i);
                        break;
                    }
                    case 'd': {
                        position = position.func_177964_d(i);
                    }
                }
                block30: for (int j = 1; j <= this.width; ++j) {
                    Block b = this.field_145850_b.func_180495_p(position).func_177230_c();
                    String bname = b.getRegistryName().toString();
                    if (j > 1) {
                        this.tempBlue.append(",");
                        this.appendStringMetas(",");
                    }
                    if (b != Blocks.field_150325_L) {
                        if (!this.mats.contains(bname)) {
                            this.mats.add(bname);
                            this.cant.add(0);
                        }
                        int id = this.mats.indexOf(bname);
                        this.tempBlue.append(id);
                        if (id > 1) {
                            this.cant.set(id, this.cant.get(id) + 1);
                        }
                        this.appendBlockStateMetas(b, this.field_145850_b.func_180495_p(position));
                    } else {
                        this.tempBlue.append(0);
                        this.appendBlockStateMetas(b, this.field_145850_b.func_180495_p(position));
                    }
                    switch (this.direction) {
                        case 'a': {
                            position = position.func_177968_d();
                            continue block30;
                        }
                        case 'b': {
                            position = position.func_177976_e();
                            continue block30;
                        }
                        case 'c': {
                            position = position.func_177978_c();
                            continue block30;
                        }
                        case 'd': {
                            position = position.func_177974_f();
                        }
                    }
                }
                this.blueprint.append(this.compressData(this.tempBlue));
                this.tempBlue = new StringBuilder();
                this.meta.append(this.compressData(this.tempMeta));
                this.metas.append(this.compressData(this.tempMetas));
                this.metae.append(this.compressData(this.tempMetae));
                this.metaw.append(this.compressData(this.tempMetaw));
                this.tempMeta = new StringBuilder();
                this.tempMetas = new StringBuilder();
                this.tempMetae = new StringBuilder();
                this.tempMetaw = new StringBuilder();
                if (i != this.deep) {
                    this.blueprint.append(";");
                    this.appendStringMetas(";");
                    continue;
                }
                if (this.level < this.height - 1) {
                    this.blueprint.append("|\"" + System.lineSeparator() + "+ \"");
                }
                if (this.level >= this.height - 1) continue;
                this.appendStringMetas("|\"" + System.lineSeparator() + "+ \"");
            }
            ++this.level;
            if (this.level == this.height) {
                try {
                    File file = new File("Archicraft_blueprint.txt");
                    PrintWriter out = new PrintWriter(file);
                    out.println("W: " + this.width + "; D: " + this.deep + "; H: " + this.height);
                    out.println("Blocks:");
                    out.println(this.mats.toString());
                    for (int i = 2; i < this.mats.size(); ++i) {
                        out.println(this.mats.get(i) + ": " + this.cant.get(i));
                    }
                    out.println("private static final String BLUEPRINT = " + System.lineSeparator() + "\"" + this.blueprint.toString() + "\";" + System.lineSeparator());
                    out.println("private static final String METADATA_NORTH = " + System.lineSeparator() + "\"" + this.meta.toString() + "\";" + System.lineSeparator());
                    out.println("private static final String METADATA_SOUTH = " + System.lineSeparator() + "\"" + this.metas.toString() + "\";" + System.lineSeparator());
                    out.println("private static final String METADATA_EAST = " + System.lineSeparator() + "\"" + this.metae.toString() + "\";" + System.lineSeparator());
                    out.println("private static final String METADATA_WEST = " + System.lineSeparator() + "\"" + this.metaw.toString() + "\";" + System.lineSeparator());
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.err.println("Scanner error. Can't print the Archicraft blueprint into file.");
                }
                this.field_145850_b.func_175698_g(this.field_174879_c);
            }
        }
        this.rest = this.cycle;
    }
}

