/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.entity;

import de.mennomax.astikorcarts.capabilities.IPull;
import de.mennomax.astikorcarts.capabilities.PullProvider;
import de.mennomax.astikorcarts.config.ModConfig;
import de.mennomax.astikorcarts.handler.PacketHandler;
import de.mennomax.astikorcarts.packets.SPacketDrawnUpdate;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractDrawn
extends Entity
implements IEntityAdditionalSpawnData {
    public static final UUID PULL_SLOWLY_MODIFIER_UUID = UUID.fromString("49B0E52E-48F2-4D89-BED7-4F5DF26F1263");
    public static final AttributeModifier PULL_SLOWLY_MODIFIER = new AttributeModifier(PULL_SLOWLY_MODIFIER_UUID, "Pull slowly modifier", ModConfig.speedModifier, 2).func_111168_a(false);
    protected Entity pulling;
    private UUID firstPullingUUID;
    @SideOnly(value=Side.CLIENT)
    private int firstPullingId;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    protected double spacing;
    @SideOnly(value=Side.CLIENT)
    private double factor;
    @SideOnly(value=Side.CLIENT)
    private float wheelrot;
    private boolean fellLastTick;
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(AbstractDrawn.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(AbstractDrawn.class, (DataSerializer)DataSerializers.field_187193_c);

    public AbstractDrawn(World worldIn) {
        super(worldIn);
        this.field_70138_W = 1.2f;
        if (worldIn.field_72995_K) {
            this.firstPullingId = -1;
        }
    }

    public void func_70071_h_() {
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (!this.func_189652_ae()) {
            this.field_70181_x -= 0.04;
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        super.func_70071_h_();
        this.tickLerp();
        if (this.pulling != null) {
            if (!this.field_70170_p.field_72995_K && this.shouldRemovePulling()) {
                this.setPulling(null);
                return;
            }
            Vec3d targetVec = this.getTargetVec();
            this.handleRotation(targetVec);
            double dRotation = this.field_70126_B - this.field_70177_z;
            if (dRotation < -180.0) {
                this.field_70126_B += 360.0f;
            } else if (dRotation >= 180.0) {
                this.field_70126_B -= 360.0f;
            }
            double lookX = MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
            double lookZ = MathHelper.func_76134_b((float)(-this.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
            double moveX = targetVec.field_72450_a - this.field_70165_t + lookX * this.spacing;
            double moveZ = targetVec.field_72449_c - this.field_70161_v + lookZ * this.spacing;
            this.field_70159_w = moveX;
            if (!this.pulling.field_70122_E && this.pulling.field_70143_R == 0.0f) {
                this.field_70181_x = targetVec.field_72448_b - this.field_70163_u;
                this.field_70143_R = 0.0f;
                this.fellLastTick = false;
            } else if (!this.fellLastTick) {
                this.field_70181_x = 0.0;
                this.fellLastTick = true;
            }
            this.field_70179_y = moveZ;
            if (this.field_70170_p.field_72995_K) {
                this.factor = Math.sqrt((moveX + lookX) * (moveX + lookX) + (moveZ + lookZ) * (moveZ + lookZ)) > 1.0 ? Math.sqrt(moveX * moveX + moveZ * moveZ) : -Math.sqrt(moveX * moveX + moveZ * moveZ);
            }
        } else {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            this.attemptReattach();
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), EntitySelectors.func_188442_a((Entity)this))) {
            this.func_70108_f(entity);
        }
    }

    public void handleRotation(Vec3d targetVecIn) {
        this.field_70177_z = (float)Math.toDegrees(-Math.atan2(targetVecIn.field_72450_a - this.field_70165_t, targetVecIn.field_72449_c - this.field_70161_v));
    }

    public Vec3d getTargetVec() {
        return new Vec3d(this.pulling.field_70165_t, this.pulling.field_70163_u, this.pulling.field_70161_v);
    }

    protected boolean shouldRemovePulling() {
        RayTraceResult result;
        if (this.pulling != null && this.field_70123_F && (result = this.field_70170_p.func_147447_a(new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v), new Vec3d(this.pulling.field_70165_t, this.pulling.field_70163_u + (double)(this.field_70131_O / 2.0f), this.pulling.field_70161_v), false, true, false)) != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            return true;
        }
        return this.pulling.field_70128_L;
    }

    public boolean canBePulledBy(Entity pullingIn) {
        return false;
    }

    public Entity getPulling() {
        return this.pulling;
    }

    public void setPulling(Entity entityIn) {
        if (this.pulling == null || entityIn == null) {
            if (!this.field_70170_p.field_72995_K) {
                if (entityIn == null) {
                    if (this.pulling != null) {
                        if (this.pulling instanceof EntityLivingBase) {
                            ((EntityLivingBase)this.pulling).func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(PULL_SLOWLY_MODIFIER);
                        }
                        ((IPull)this.pulling.getCapability(PullProvider.PULL, null)).setDrawn(null);
                        this.func_184185_a(SoundEvents.field_187635_cQ, 0.5f, 0.1f);
                    }
                    ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a((Entity)this, PacketHandler.INSTANCE.getPacketFrom((IMessage)new SPacketDrawnUpdate(-1, this.func_145782_y())));
                } else {
                    if (entityIn instanceof EntityLiving) {
                        ((EntityLiving)entityIn).func_70661_as().func_75499_g();
                    }
                    ((IPull)entityIn.getCapability(PullProvider.PULL, null)).setDrawn(this);
                    ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a((Entity)this, PacketHandler.INSTANCE.getPacketFrom((IMessage)new SPacketDrawnUpdate(entityIn.func_145782_y(), this.func_145782_y())));
                    this.func_184185_a(SoundEvents.field_187702_cm, 0.5f, 1.0f);
                }
            }
            this.pulling = entityIn;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean setPullingId(int entityId) {
        Entity entity = this.field_70170_p.func_73045_a(entityId);
        if (entity != null) {
            this.setPulling(entity);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getWheelRotation() {
        if (this.pulling != null && !Minecraft.func_71410_x().func_147113_T()) {
            this.wheelrot = (float)((double)this.wheelrot - (double)0.12f * this.factor);
        }
        return this.wheelrot;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (source instanceof EntityDamageSourceIndirect && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            boolean bl = flag = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamageTaken() > 40.0f) {
                this.onDestroyed(source, flag);
                this.setPulling(null);
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    public abstract Item getCartItem();

    public void onDestroyed(DamageSource source, boolean byCreativePlayer) {
        if (!byCreativePlayer && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_145778_a(this.getCartItem(), 1, 0.0f);
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getCartItem());
    }

    private void attemptReattach() {
        Entity pulling;
        if (this.field_70170_p.field_72995_K) {
            if (this.firstPullingId != -1 && this.setPullingId(this.firstPullingId)) {
                this.firstPullingId = -1;
            }
        } else if (this.firstPullingUUID != null && (pulling = ((WorldServer)this.field_70170_p).func_175733_a(this.firstPullingUUID)) != null) {
            this.setPulling(pulling);
            this.firstPullingUUID = null;
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.firstPullingUUID = compound.func_186857_a("FirstPullingUUID");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.pulling != null) {
            compound.func_186854_a("FirstPullingUUID", this.pulling.func_110124_au());
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.pulling != null) {
            buffer.writeInt(this.pulling.func_145782_y());
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        int entityId;
        if (additionalData.readableBytes() >= 4 && !this.setPullingId(entityId = additionalData.readInt())) {
            this.firstPullingId = entityId;
        }
    }

    private void tickLerp() {
        if (this.lerpSteps > 0) {
            double dx = this.field_70165_t + (this.lerpX - this.field_70165_t) / (double)this.lerpSteps;
            double dy = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double dz = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            double drot = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + drot / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(dx, dy, dz);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpSteps = 10;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.field_70165_t = this.lerpX;
            this.field_70163_u = this.lerpY;
            this.field_70161_v = this.lerpZ;
            this.field_70177_z = (float)this.lerpYaw;
        }
    }
}

