/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.client.oregon;

import cpw.mods.modlauncher.api.INameMappingService;
import de.mennomax.astikorcarts.AstikorCarts;
import de.mennomax.astikorcarts.oregon.BasicProgram;
import de.mennomax.astikorcarts.oregon.Oregon;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.StatsScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.stats.Stat;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class OregonSubscriber {
    private static final Logger LOGGER = LogManager.getLogger();
    private State state = new IdleState();

    @SubscribeEvent
    public void onScreenKeyPressed(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        block4: {
            Screen screen;
            block5: {
                Minecraft mc = Minecraft.func_71410_x();
                screen = event.getGui();
                if (screen instanceof StatsScreen && (event.getKeyCode() == 257 || event.getKeyCode() == 335) && mc.field_71439_g != null) {
                    this.getSelectedStat((StatsScreen)screen).ifPresent(stat -> {
                        if (AstikorCarts.Stats.CART_ONE_CM.equals(stat.func_197920_b()) && mc.field_71439_g.func_146107_m().func_77444_a(stat) > 204000) {
                            PlayerIO io = new PlayerIO();
                            Oregon oregon = new Oregon(io, new Random());
                            this.setState(new ActiveState(new Thread(() -> {
                                try {
                                    oregon.run();
                                }
                                finally {
                                    mc.func_212871_a_(() -> this.setState(new IdleState()));
                                }
                            }, "Oregon Trail 1978"), io));
                        }
                    });
                }
                if (!(screen instanceof ChatScreen)) break block4;
                if (event.getKeyCode() == 257) break block5;
                if (event.getKeyCode() != 335) break block4;
            }
            screen.children().stream().filter(TextFieldWidget.class::isInstance).map(TextFieldWidget.class::cast).findFirst().ifPresent(field -> {
                if (this.state.onChat((TextFieldWidget)field)) {
                    event.setCanceled(true);
                }
            });
        }
    }

    private Optional<Stat<?>> getSelectedStat(StatsScreen screen) {
        Stat stat;
        Class<?> classCustomStatsList$Entry;
        ExtendedList list = screen.func_213116_d();
        if (list == null) {
            return Optional.empty();
        }
        try {
            classCustomStatsList$Entry = Class.forName("net.minecraft.client.gui.screen.StatsScreen$CustomStatsList$Entry");
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Unable to lookup custom stat entry class", (Throwable)e);
            return Optional.empty();
        }
        AbstractList.AbstractListEntry entry = list.getSelected();
        if (!classCustomStatsList$Entry.isInstance(entry)) {
            return Optional.empty();
        }
        String statFieldName = ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)"field_214405_b");
        try {
            Field fieldStat = classCustomStatsList$Entry.getDeclaredField(statFieldName);
            fieldStat.setAccessible(true);
            stat = (Stat)fieldStat.get(entry);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Unable to retrieve stat from entry; fields: {}", Arrays.asList(StatsScreen.class.getDeclaredFields()), (Object)e);
            return Optional.empty();
        }
        return Optional.of(stat);
    }

    private void setState(State newState) {
        this.state.stop();
        this.state = newState;
        this.state.start();
    }

    static class PlayerIO
    implements BasicProgram.IO {
        final BlockingDeque<String> in = new LinkedBlockingDeque<String>();

        PlayerIO() {
        }

        void add(String s) {
            this.in.addLast(s);
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                player.func_145747_a(new StringTextComponent(s).func_150255_a(new Style().func_150217_b(Boolean.valueOf(true)).func_150238_a(TextFormatting.WHITE)));
            }
        }

        @Override
        public int prompt(int lower, int upper) throws InterruptedException {
            try {
                return Integer.parseInt(this.in.takeFirst());
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }

        @Override
        public String prompt(String ... options) throws InterruptedException {
            return this.in.takeFirst();
        }

        @Override
        public void print(String s) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_213167_f(() -> {
                ClientPlayerEntity player = mc.field_71439_g;
                if (player != null) {
                    player.func_145747_a(new StringTextComponent(s).func_150255_a(new Style().func_150217_b(Boolean.valueOf(true)).func_150238_a(TextFormatting.GRAY)));
                }
            });
        }
    }

    static class ActiveState
    extends State {
        final Thread thread;
        final PlayerIO io;

        ActiveState(Thread thread, PlayerIO io) {
            this.thread = thread;
            this.io = io;
        }

        @Override
        void start() {
            this.thread.setDaemon(true);
            this.thread.start();
            Minecraft.func_71410_x().func_147108_a((Screen)new ChatScreen("? "));
        }

        @Override
        void stop() {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r instanceof ChatScreen) {
                mc.func_147108_a(null);
            }
        }

        @Override
        public boolean onChat(TextFieldWidget field) {
            String text = field.func_146179_b();
            if (text.startsWith("?")) {
                this.io.add(text.substring(1).trim());
                field.func_146180_a("? ");
                return true;
            }
            return false;
        }
    }

    static class IdleState
    extends State {
        IdleState() {
        }

        @Override
        void start() {
        }

        @Override
        void stop() {
        }

        @Override
        public boolean onChat(TextFieldWidget field) {
            return false;
        }
    }

    static abstract class State {
        State() {
        }

        abstract void start();

        abstract void stop();

        abstract boolean onChat(TextFieldWidget var1);
    }
}

