/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.client.renderer.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import de.mennomax.astikorcarts.entity.AbstractDrawnEntity;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public abstract class DrawnRenderer<T extends AbstractDrawnEntity, M extends EntityModel<T>>
extends EntityRenderer<T> {
    protected M model;

    protected DrawnRenderer(EntityRendererManager renderManager, M model) {
        super(renderManager);
        this.model = model;
    }

    public void doRender(T entity, double x, double y, double z, float yaw, float delta) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x), (float)((float)y), (float)((float)z));
        AbstractDrawnEntity.RenderInfo info = ((AbstractDrawnEntity)((Object)entity)).getInfo(delta);
        this.setupRotation(entity, info.getYaw(), delta);
        this.func_180548_c((Entity)entity);
        if (this.field_188301_f) {
            GlStateManager.enableColorMaterial();
            GlStateManager.setupSolidRenderingTextureCombine((int)this.func_188298_c((Entity)entity));
        }
        this.model.func_78088_a(entity, delta, 0.0f, 0.0f, 0.0f, info.getPitch(), 0.0625f);
        this.renderContents(entity, delta);
        if (this.field_188301_f) {
            GlStateManager.tearDownSolidRenderingTextureCombine();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.popMatrix();
        super.func_76986_a(entity, x, y, z, info.getYaw(), delta);
    }

    protected void renderContents(T entity, float delta) {
    }

    public void setupRotation(T entity, float entityYaw, float delta) {
        GlStateManager.rotatef((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        float time = (float)((AbstractDrawnEntity)((Object)entity)).getTimeSinceHit() - delta;
        if (time > 0.0f) {
            double center = 1.2;
            GlStateManager.translated((double)0.0, (double)1.2, (double)0.0);
            float damage = Math.max(((AbstractDrawnEntity)((Object)entity)).getDamageTaken() - delta, 0.0f);
            float angle = MathHelper.func_76126_a((float)time) * time * damage / 60.0f;
            GlStateManager.rotatef((float)(angle * (float)((AbstractDrawnEntity)((Object)entity)).getForwardDirection()), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.translated((double)0.0, (double)-1.2, (double)0.0);
            GlStateManager.translated((double)0.0, (double)(angle / 32.0f), (double)0.0);
        }
        GlStateManager.scalef((float)-1.0f, (float)-1.0f, (float)1.0f);
    }
}

