/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.util;

import de.mennomax.astikorcarts.entity.AbstractDrawnEntity;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public final class CartWheel {
    private float rotation;
    private float rotationIncrement;
    private final float offsetX;
    private final float offsetZ;
    private final float circumference;
    private double posX;
    private double posZ;
    private double prevPosX;
    private double prevPosZ;
    private final AbstractDrawnEntity cart;

    public CartWheel(AbstractDrawnEntity cartIn, float offsetXIn, float offsetZIn, float circumferenceIn) {
        this.cart = cartIn;
        this.offsetX = offsetXIn;
        this.offsetZ = offsetZIn;
        this.circumference = circumferenceIn;
        this.posX = this.prevPosX = cartIn.field_70165_t;
        this.posZ = this.prevPosZ = cartIn.field_70161_v;
    }

    public CartWheel(AbstractDrawnEntity cartIn, float offsetX) {
        this(cartIn, offsetX, 0.0f, 3.9269907f);
    }

    public void tick() {
        BlockPos blockpos;
        BlockState blockstate;
        this.rotation += this.rotationIncrement;
        this.prevPosX = this.posX;
        this.prevPosZ = this.posZ;
        float yaw = (float)Math.toRadians(this.cart.field_70177_z);
        float nx = -MathHelper.func_76126_a((float)yaw);
        float nz = MathHelper.func_76134_b((float)yaw);
        this.posX = this.cart.field_70165_t + (double)(nx * this.offsetZ) - (double)(nz * this.offsetX);
        this.posZ = this.cart.field_70161_v + (double)(nz * this.offsetZ) + (double)(nx * this.offsetX);
        double dx = this.posX - this.prevPosX;
        double dz = this.posZ - this.prevPosZ;
        float distanceTravelled = (float)Math.sqrt(dx * dx + dz * dz);
        double dxNormalized = dx / (double)distanceTravelled;
        double dzNormalized = dz / (double)distanceTravelled;
        float travelledForward = MathHelper.func_219802_k((double)(dxNormalized * (double)nx + dzNormalized * (double)nz));
        if ((double)distanceTravelled > 0.2 && !(blockstate = this.cart.field_70170_p.func_180495_p(blockpos = new BlockPos(MathHelper.func_76128_c((double)this.posX), MathHelper.func_76128_c((double)(this.cart.field_70163_u - (double)0.2f)), MathHelper.func_76128_c((double)this.posZ)))).addRunningEffects(this.cart.field_70170_p, blockpos, (Entity)this.cart) && blockstate.func_185901_i() != BlockRenderType.INVISIBLE) {
            this.cart.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(blockpos), this.posX, this.cart.field_70163_u, this.posZ, dx, (double)distanceTravelled, dz);
        }
        this.rotationIncrement = travelledForward * distanceTravelled * this.circumference * 0.2f;
    }

    public void clearIncrement() {
        this.rotationIncrement = 0.0f;
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getRotationIncrement() {
        return this.rotationIncrement;
    }
}

