/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts;

import com.google.common.collect.ImmutableMap;
import de.mennomax.astikorcarts.AstikorCarts;
import de.mennomax.astikorcarts.Initializer;
import de.mennomax.astikorcarts.config.AstikorCartsConfig;
import de.mennomax.astikorcarts.entity.PostilionEntity;
import de.mennomax.astikorcarts.entity.ai.goal.PullCartGoal;
import de.mennomax.astikorcarts.entity.ai.goal.RideCartGoal;
import de.mennomax.astikorcarts.util.GoalAdder;
import de.mennomax.astikorcarts.util.RegObject;
import de.mennomax.astikorcarts.world.AstikorWorld;
import de.mennomax.astikorcarts.world.SimpleAstikorWorld;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CommonInitializer
implements Initializer {
    @Override
    public void init(Initializer.Context mod) {
        mod.context().registerConfig(ModConfig.Type.COMMON, AstikorCartsConfig.COMMON_SPEC);
        mod.modBus().addListener(e -> CapabilityManager.INSTANCE.register(AstikorWorld.class, (Capability.IStorage)new Capability.IStorage<AstikorWorld>(){

            @Nullable
            public INBT writeNBT(Capability<AstikorWorld> capability, AstikorWorld instance, Direction side) {
                return null;
            }

            public void readNBT(Capability<AstikorWorld> capability, AstikorWorld instance, Direction side, INBT nbt) {
            }
        }, SimpleAstikorWorld::new));
        mod.bus().addGenericListener(World.class, e -> e.addCapability(new ResourceLocation("astikorcarts", "astikor"), AstikorWorld.createProvider((NonNullSupplier<AstikorWorld>)((NonNullSupplier)SimpleAstikorWorld::new))));
        mod.bus().register(GoalAdder.mobGoal(MobEntity.class).add(1, PullCartGoal::new).add(1, RideCartGoal::new).build());
        mod.bus().addListener(e -> {
            Entity rider = e.getTarget().func_184179_bs();
            if (rider instanceof PostilionEntity) {
                rider.func_184210_p();
            }
        });
        mod.bus().addListener(e -> {
            if (e.phase == TickEvent.Phase.END) {
                AstikorWorld.get(e.world).ifPresent(AstikorWorld::tick);
            }
        });
        mod.bus().addGenericListener(Item.class, this.remap((Map)ImmutableMap.builder().put((Object)"cargocart", AstikorCarts.Items.CARGO_CART).put((Object)"plowcart", AstikorCarts.Items.PLOW_CART).put((Object)"mobcart", AstikorCarts.Items.MOB_CART).build()));
        mod.bus().addGenericListener(EntityType.class, this.remap((Map)ImmutableMap.builder().put((Object)"cargocart", AstikorCarts.EntityTypes.CARGO_CART).put((Object)"plowcart", AstikorCarts.EntityTypes.PLOW_CART).put((Object)"mobcart", AstikorCarts.EntityTypes.MOB_CART).build()));
    }

    private <T extends IForgeRegistryEntry<T>> Consumer<RegistryEvent.MissingMappings<T>> remap(Map<String, RegObject<T, ? extends T>> objects) {
        return e -> {
            for (RegistryEvent.MissingMappings.Mapping mapping : e.getAllMappings()) {
                RegObject target;
                if (!"astikorcarts".equals(mapping.key.func_110624_b()) || (target = (RegObject)objects.get(mapping.key.func_110623_a())) == null) continue;
                mapping.remap(target.get());
            }
        };
    }
}

