/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.config;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public final class AstikorCartsConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)specPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
    }

    public static class Common {
        public final ForgeConfigSpec.DoubleValue speedModifier;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> cargoPullable;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> plowPullable;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> mobPullable;
        public final ForgeConfigSpec.ConfigValue<Config> plowReplace;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("common");
            this.speedModifier = builder.comment("Speed modifier for when the sprint key is pressed while riding a living entity").worldRestart().defineInRange("speedModifier", -0.65, -1.0, 0.0);
            this.cargoPullable = builder.comment("List of entities that are allowed to pull this cart.").define("cargoCart.pullEntities", new ArrayList<String>(Arrays.asList("minecraft:horse", "minecraft:donkey", "minecraft:mule", "minecraft:pig")));
            this.plowPullable = builder.comment("List of entities that are allowed to pull this cart.").define("plowCart.pullEntities", new ArrayList<String>(Arrays.asList("minecraft:horse", "minecraft:donkey", "minecraft:mule", "minecraft:pig")));
            this.mobPullable = builder.comment("List of entities that are allowed to pull this cart.").define("mobCart.pullEntities", new ArrayList<String>(Arrays.asList("minecraft:horse", "minecraft:donkey", "minecraft:mule", "minecraft:pig")));
            HashMap<String, Config> itemReplaceMap = new HashMap<String, Config>();
            HashMap<String, List<String>> hoeReplaceMap = new HashMap<String, List<String>>();
            hoeReplaceMap.put("minecraft:farmland", Arrays.asList("minecraft:dirt", "minecraft:grass_block", "minecraft:grass_path"));
            hoeReplaceMap.put("minecraft:dirt", Arrays.asList("minecraft:coarse_dirt"));
            itemReplaceMap.put("#forge:tools/hoes", Config.wrap(hoeReplaceMap, (ConfigFormat)TomlFormat.instance()));
            HashMap<String, List<String>> shovelReplaceMap = new HashMap<String, List<String>>();
            shovelReplaceMap.put("minecraft:grass_path", Arrays.asList("minecraft:grass_block", "minecraft:dirt"));
            itemReplaceMap.put("#forge:tools/shovels", Config.wrap(shovelReplaceMap, (ConfigFormat)TomlFormat.instance()));
            this.plowReplace = builder.comment("<new block> -> <old blocks> mappings to replace blocks (for example to till dirt with a hoe).\nIf the item can be damaged, it will be damaged, else it will be consumed - unless the player is in creative mode.\nItem and the value list also supports tags.").define("plowCart.replaceMap", (Object)Config.wrap(itemReplaceMap, (ConfigFormat)TomlFormat.instance()));
            builder.pop();
        }
    }
}

