/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.entity;

import de.mennomax.astikorcarts.AstikorCarts;
import de.mennomax.astikorcarts.config.AstikorCartsConfig;
import de.mennomax.astikorcarts.entity.AbstractDrawnInventoryEntity;
import de.mennomax.astikorcarts.inventory.container.CargoCartContainer;
import de.mennomax.astikorcarts.util.CartItemStackHandler;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public final class CargoCartEntity
extends AbstractDrawnInventoryEntity {
    private static final DataParameter<Integer> CARGO = EntityDataManager.func_187226_a(CargoCartEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public CargoCartEntity(EntityType<? extends Entity> type, World world) {
        super(type, world);
    }

    @Override
    protected ArrayList<String> getAllowedEntityList() {
        return (ArrayList)AstikorCartsConfig.COMMON.cargoPullable.get();
    }

    @Override
    protected ItemStackHandler initInventory() {
        return new CartItemStackHandler<CargoCartEntity>(54, this){

            protected void onContentsChanged(int slot) {
                int tempload = 0;
                for (int i = 0; i < this.getSlots(); ++i) {
                    if (this.getStackInSlot(i).func_190926_b()) continue;
                    ++tempload;
                }
                int newValue = tempload > 31 ? 4 : (tempload > 16 ? 3 : (tempload > 8 ? 2 : (tempload > 3 ? 1 : 0)));
                ((CargoCartEntity)this.cart).func_184212_Q().func_187227_b(CARGO, (Object)newValue);
            }
        };
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K) {
            if (player.func_213453_ef()) {
                this.openContainer(player);
            } else {
                player.func_184220_m((Entity)this);
            }
        }
        return true;
    }

    public double func_70042_X() {
        return 0.6875;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            Vec3d forward = this.func_70040_Z();
            Vec3d origin = new Vec3d(0.0, this.func_70042_X(), 0.0625);
            Vec3d pos = origin.func_178787_e(forward.func_186678_a(-0.68));
            passenger.func_70107_b(this.func_226277_ct_() + pos.field_72450_a, this.func_226278_cu_() + pos.field_72448_b - 0.1 + passenger.func_70033_W(), this.func_226281_cx_() + pos.field_72449_c);
            passenger.func_181013_g(this.field_70177_z + 180.0f);
            float f2 = MathHelper.func_76142_g((float)(passenger.field_70177_z - this.field_70177_z + 180.0f));
            float f1 = MathHelper.func_76131_a((float)f2, (float)-105.0f, (float)105.0f);
            passenger.field_70126_B += f1 - f2;
            passenger.field_70177_z += f1 - f2;
            passenger.func_70034_d(passenger.field_70177_z);
        }
    }

    public int getCargo() {
        return (Integer)this.field_70180_af.func_187225_a(CARGO);
    }

    @Override
    public Item getCartItem() {
        return AstikorCarts.Items.CARGO_CART.get();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CARGO, (Object)0);
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(CARGO, (Object)compound.func_74762_e("Cargo"));
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Cargo", ((Integer)this.field_70180_af.func_187225_a(CARGO)).intValue());
    }

    public void openContainer(PlayerEntity player) {
        player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((id, inv, plyr) -> new CargoCartContainer(id, inv, (AbstractDrawnInventoryEntity)this), this.func_145748_c_()));
    }
}

