/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.entity;

import com.google.common.collect.ImmutableList;
import de.mennomax.astikorcarts.AstikorCarts;
import de.mennomax.astikorcarts.config.AstikorCartsConfig;
import de.mennomax.astikorcarts.entity.AbstractDrawnInventoryEntity;
import de.mennomax.astikorcarts.inventory.container.PlowCartContainer;
import de.mennomax.astikorcarts.util.CartItemStackHandler;
import de.mennomax.astikorcarts.util.PlowBlockHandler;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemStackHandler;

public final class PlowCartEntity
extends AbstractDrawnInventoryEntity {
    private static final double BLADEOFFSET = 1.7;
    private static final DataParameter<Boolean> PLOWING = EntityDataManager.func_187226_a(PlowCartEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final ImmutableList<DataParameter<ItemStack>> TOOLS = ImmutableList.of((Object)EntityDataManager.func_187226_a(PlowCartEntity.class, (IDataSerializer)DataSerializers.field_187196_f), (Object)EntityDataManager.func_187226_a(PlowCartEntity.class, (IDataSerializer)DataSerializers.field_187196_f), (Object)EntityDataManager.func_187226_a(PlowCartEntity.class, (IDataSerializer)DataSerializers.field_187196_f));
    private final PlowBlockHandler[] plowRunners = new PlowBlockHandler[3];

    public PlowCartEntity(EntityType<? extends Entity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.spacing = 2.0;
        for (int i = 0; i < TOOLS.size(); ++i) {
            this.updateRunnerForSlot(i, this.inventory.getStackInSlot(i));
        }
    }

    @Override
    protected ArrayList<String> getAllowedEntityList() {
        return (ArrayList)AstikorCartsConfig.COMMON.plowPullable.get();
    }

    @Override
    protected ItemStackHandler initInventory() {
        return new CartItemStackHandler<PlowCartEntity>(3, this){

            protected void onLoad() {
                for (int i = 0; i < TOOLS.size(); ++i) {
                    ((PlowCartEntity)this.cart).func_184212_Q().func_187227_b((DataParameter)TOOLS.get(i), (Object)this.getStackInSlot(i));
                    ((PlowCartEntity)this.cart).updateRunnerForSlot(i, this.getStackInSlot(i));
                }
            }

            protected void onContentsChanged(int slot) {
                ((PlowCartEntity)this.cart).updateSlot(slot);
            }
        };
    }

    public boolean getPlowing() {
        return (Boolean)this.field_70180_af.func_187225_a(PLOWING);
    }

    @Override
    public void pulledTick() {
        super.pulledTick();
        if (this.getPulling() == null) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            PlayerEntity player = null;
            if (this.getPulling() instanceof PlayerEntity) {
                player = (PlayerEntity)this.getPulling();
            } else if (this.getPulling().func_184179_bs() instanceof PlayerEntity) {
                player = (PlayerEntity)this.getPulling().func_184179_bs();
            }
            if (((Boolean)this.field_70180_af.func_187225_a(PLOWING)).booleanValue() && player != null && (this.field_70169_q != this.func_226277_ct_() || this.field_70166_s != this.func_226281_cx_())) {
                for (int i = 0; i < this.inventory.getSlots(); ++i) {
                    float offset = 38.0f - (float)i * 38.0f;
                    double blockPosX = this.func_226277_ct_() + (double)MathHelper.func_76126_a((float)((this.field_70177_z - offset) * ((float)Math.PI / 180))) * 1.7;
                    double blockPosZ = this.func_226281_cx_() - (double)MathHelper.func_76134_b((float)((this.field_70177_z - offset) * ((float)Math.PI / 180))) * 1.7;
                    BlockPos blockPos = new BlockPos(blockPosX, this.func_226278_cu_() - 0.5, blockPosZ);
                    this.plowRunners[i].tillBlock(player, blockPos);
                }
            }
        }
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K) {
            if (player.func_213453_ef()) {
                this.openContainer(player);
            } else {
                this.field_70180_af.func_187227_b(PLOWING, (Object)((Boolean)this.field_70180_af.func_187225_a(PLOWING) == false ? 1 : 0));
            }
        }
        return true;
    }

    public void updateRunnerForSlot(int slot, ItemStack stack) {
        this.plowRunners[slot] = new PlowBlockHandler(stack, slot, this);
    }

    public void updateSlot(int slot) {
        if (!this.field_70170_p.field_72995_K) {
            this.updateRunnerForSlot(slot, this.inventory.getStackInSlot(slot));
            if (this.inventory.getStackInSlot(slot).func_190926_b()) {
                this.field_70180_af.func_187227_b((DataParameter)TOOLS.get(slot), (Object)ItemStack.field_190927_a);
            } else {
                this.field_70180_af.func_187227_b((DataParameter)TOOLS.get(slot), (Object)this.inventory.getStackInSlot(slot));
            }
        }
    }

    public ItemStack getStackInSlot(int i) {
        return (ItemStack)this.field_70180_af.func_187225_a((DataParameter)TOOLS.get(i));
    }

    @Override
    public Item getCartItem() {
        return AstikorCarts.Items.PLOW_CART.get();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLOWING, (Object)false);
        for (DataParameter param : TOOLS) {
            this.field_70180_af.func_187214_a(param, (Object)ItemStack.field_190927_a);
        }
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(PLOWING, (Object)compound.func_74767_n("Plowing"));
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Plowing", ((Boolean)this.field_70180_af.func_187225_a(PLOWING)).booleanValue());
    }

    private void openContainer(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, p) -> new PlowCartContainer(windowId, playerInventory, (AbstractDrawnInventoryEntity)this), this.func_145748_c_()), buf -> buf.writeInt(this.func_145782_y()));
        }
    }
}

