/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.util;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class GoalAdder<T extends Entity> {
    private static final Field GOALS = ObfuscationReflectionHelper.findField(GoalSelector.class, (String)"field_220892_d");
    private final Class<T> type;
    private final Function<T, GoalSelector> selector;
    private final ImmutableList<GoalEntry<T>> goals;

    private GoalAdder(Builder<T> builder) {
        this.type = ((Builder)builder).type;
        this.selector = ((Builder)builder).selector;
        this.goals = ((Builder)builder).goals.build();
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (!entity.field_70170_p.field_72995_K && this.type.isInstance(entity)) {
            Set<PrioritizedGoal> oldGoals = this.getGoals((Entity)this.type.cast(entity));
            ArrayList<PrioritizedGoal> newGoals = new ArrayList<PrioritizedGoal>(oldGoals.size() + this.goals.size());
            for (GoalEntry goal : this.goals) {
                newGoals.add(new PrioritizedGoal(goal.priority, (Goal)goal.factory.apply(this.type.cast(entity))));
            }
            newGoals.addAll(oldGoals);
            oldGoals.clear();
            oldGoals.addAll(newGoals);
        }
    }

    private Set<PrioritizedGoal> getGoals(T entity) {
        try {
            return (Set)GOALS.get(this.selector.apply(entity));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends MobEntity> Builder<T> mobGoal(Class<T> type) {
        return GoalAdder.builder(type, m -> m.field_70714_bg);
    }

    public static <T extends MobEntity> Builder<T> mobTarget(Class<T> type) {
        return GoalAdder.builder(type, m -> m.field_70715_bh);
    }

    public static <T extends Entity> Builder<T> builder(Class<T> type, Function<T, GoalSelector> selector) {
        return new Builder(type, selector);
    }

    private static final class GoalEntry<T extends Entity> {
        private final int priority;
        private final Function<T, Goal> factory;

        private GoalEntry(int priority, Function<T, Goal> factory) {
            this.priority = priority;
            this.factory = factory;
        }
    }

    public static final class Builder<T extends Entity> {
        private final Class<T> type;
        private final Function<T, GoalSelector> selector;
        private final ImmutableList.Builder<GoalEntry<T>> goals = new ImmutableList.Builder();

        private Builder(Class<T> type, Function<T, GoalSelector> selector) {
            this.type = type;
            this.selector = selector;
        }

        public Builder<T> add(int priority, Function<T, Goal> factory) {
            this.goals.add(new GoalEntry(priority, factory));
            return this;
        }

        public GoalAdder<T> build() {
            return new GoalAdder(this);
        }
    }
}

