/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.util;

import com.electronwill.nightconfig.core.Config;
import de.mennomax.astikorcarts.config.AstikorCartsConfig;
import de.mennomax.astikorcarts.entity.PlowCartEntity;
import de.mennomax.astikorcarts.util.PlowExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public final class PlowBlockHandler {
    private final List<PlowExecutor> executors = new ArrayList<PlowExecutor>(2);
    private final ItemStack stack;
    private final int slot;
    private final PlowCartEntity plow;

    public PlowBlockHandler(ItemStack stackIn, int slotIn, PlowCartEntity plowIn) {
        this.stack = stackIn;
        this.slot = slotIn;
        this.plow = plowIn;
        String registryName = this.stack.func_77973_b().getRegistryName().toString();
        Config itemReplaceMap = (Config)((Config)AstikorCartsConfig.COMMON.plowReplace.get()).get(registryName);
        if (itemReplaceMap == null) {
            if (this.stack.func_77973_b() instanceof HoeItem) {
                itemReplaceMap = (Config)((Config)AstikorCartsConfig.COMMON.plowReplace.get()).get("#forge:tools/hoes");
            } else if (this.stack.func_77973_b() instanceof ShovelItem) {
                itemReplaceMap = (Config)((Config)AstikorCartsConfig.COMMON.plowReplace.get()).get("#forge:tools/shovels");
            } else {
                for (ResourceLocation rl : this.stack.func_77973_b().getTags()) {
                    itemReplaceMap = (Config)((Config)AstikorCartsConfig.COMMON.plowReplace.get()).get(rl.toString());
                    if (itemReplaceMap == null) continue;
                    break;
                }
            }
        }
        if (itemReplaceMap != null) {
            HashMap<ArrayList<Block>, Block> replaceMap = new HashMap<ArrayList<Block>, Block>();
            for (Config.Entry entry : itemReplaceMap.entrySet()) {
                ArrayList<Block> blockList = new ArrayList<Block>();
                for (String blockId : (List)entry.getValue()) {
                    Block toAdd = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
                    if (toAdd == null) {
                        blockList.addAll(BlockTags.func_199896_a().func_199910_a(new ResourceLocation(blockId)).func_199885_a());
                        continue;
                    }
                    blockList.add(toAdd);
                }
                replaceMap.put(blockList, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entry.getKey())));
            }
            this.executors.add(new ReplaceHandler(replaceMap));
        }
    }

    public void tillBlock(PlayerEntity player, BlockPos blockPos) {
        for (PlowExecutor exe : this.executors) {
            exe.tillBlock(player, blockPos);
        }
    }

    private void handleStackDamage(PlayerEntity player, ItemStack stack) {
        if (!player.func_184812_l_()) {
            if (stack.func_77984_f()) {
                ItemStack copy = stack.func_77946_l();
                stack.func_222118_a(1, (LivingEntity)player, e -> {});
                if (stack.func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)copy, null);
                    this.plow.updateSlot(this.slot);
                    this.plow.field_70170_p.func_184134_a(this.plow.func_226277_ct_(), this.plow.func_226278_cu_(), this.plow.func_226281_cx_(), SoundEvents.field_187635_cQ, this.plow.func_184176_by(), 0.8f, 0.8f + this.plow.field_70170_p.field_73012_v.nextFloat() * 0.4f, false);
                }
            } else {
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    this.plow.updateSlot(this.slot);
                }
            }
        }
    }

    private Block getFirstMatch(HashMap<ArrayList<Block>, Block> replaceMap, BlockState toReplaceState) {
        for (ArrayList<Block> matchList : replaceMap.keySet()) {
            for (Block match : matchList) {
                if (match != toReplaceState.func_177230_c()) continue;
                return replaceMap.get(matchList);
            }
        }
        return null;
    }

    private class ReplaceHandler
    implements PlowExecutor {
        private final HashMap<ArrayList<Block>, Block> replaceMap;

        public ReplaceHandler(HashMap<ArrayList<Block>, Block> replaceMapIn) {
            this.replaceMap = replaceMapIn;
        }

        @Override
        public void tillBlock(PlayerEntity player, BlockPos pos) {
            BlockState toReplaceState = player.field_70170_p.func_180495_p(pos);
            Block replaceWith = PlowBlockHandler.this.getFirstMatch(this.replaceMap, toReplaceState);
            if (replaceWith != null) {
                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(player.field_70170_p, pos, toReplaceState, player);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (!event.isCanceled()) {
                    player.field_70170_p.func_175656_a(pos, replaceWith.func_176223_P());
                    PlowBlockHandler.this.handleStackDamage(player, PlowBlockHandler.this.stack);
                }
            }
        }
    }
}

